<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>审查员管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
		});
	</script>
	<!--引入wangEditor.css-->
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/handeler/handlerShowReferee/">审查员列表</a></li>
		<li class="active"><a href="${ctx}/handeler/handlerShowReferee/form?id=${groomerShowReferee.id}">审查员<shiro:hasPermission name="handeler:handlerShowReferee:edit">${not empty groomerShowReferee.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="handeler:handlerShowReferee:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerShowReferee" action="${ctx}/handeler/handlerShowReferee/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">审查员中文名：</label>
			<div class="controls">
				<form:input path="refereeNameCn" htmlEscape="false" maxlength="64" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员英文名：</label>
			<div class="controls">
				<form:input path="refereeNameEn" htmlEscape="false" maxlength="64" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员性别：</label>
			<div class="controls">
				<form:select path="refereeSex" class="input-small required" disabled="true">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('sex')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员国籍：</label>
			<div class="controls">
				<form:input path="refereeCitizenship" htmlEscape="false" maxlength="64" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员图片：</label>
			<div class="controls">
				<div style="float:left;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty groomerShowReferee.refereePicture }">
							<center><img id="previewCatImg" alt="" src="" style="padding:10px;height:130px;" disabled="true"/></center>
						</c:if>
						<c:if test="${not empty groomerShowReferee.refereePicture }">
							<center><img id="previewCatImg" alt="" src="${ctx }/sys/file/image/${groomerShowReferee.refereePicture }"disabled="true" style="padding:10px;height:130px;"/></center>
						</c:if>
					</div>
				</div>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员介绍：</label>
			<div class="controls">
				<form:textarea  htmlEscape="true" path="refereeIntroduce" style="height:400px"  disabled="true" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审查员头衔：</label>
			<div class="controls">
				<form:input path="refereeTitle" htmlEscape="false" maxlength="200" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">link_order：</label>
			<div class="controls">
				<form:input path="refereeLinkOrder" htmlEscape="false" maxlength="200" class="input-xlarge " disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " disabled="true"/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script type="text/javascript" src="${ctxStatic }/wangEditor/js/wangEditor.min.js"></script>
	<script type="text/javascript">
		var editor = new wangEditor('refereeIntroduce');
		// 上传图片（举例）
		editor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';

		editor.config.uploadImgFileName = 'editorImg';
		// 设置 headers（举例）
		editor.config.uploadHeaders = {
			'Accept' : 'text/x-json'
		};

		// 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
		editor.config.hideLinkImg = true;
		editor.create();
	</script>
</body>
</html>