<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>成绩管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //复选框回显
            var id = $("#id").val();
            $.ajax({
                type: "POST",
                url: ctx + "/groomer/groomerRegister/getRegisterMessage",
                data: {'id': id},
                dataType: 'json',
                async: false,
                success: function (jsons) {
                    if (jsons.length > 0) {
                        $.each(jsons, function (index, item) {
                            if (item == '无' || item == '贵宾' || item == '比熊' || item == '雪纳瑞' || item == '模型') {
                                $("input[type=checkbox][name='showDogBreed'][value=" + item + "]").attr("checked", 'checked');
                            } else {
                                $("input[type=text][name='showDogBreed']").val(item);
                            }
                        });
                    }
                }
            });
            var showCategory = '${groomerRegister.groomerShow.showCategory}';
            //美容师资格认证
            if (showCategory == '1') {
                $("#otherLevelO").show();
                $("#otherLevelT").hide();
                $("#otherLevelR").hide();
                $("#otherLevelNurse").hide();
            }
            //国际宠物美容师认证
            if (showCategory == '2') {
                $("#otherLevelO").hide();
                $("#otherLevelT").show();
                $("#otherLevelR").hide();
                $("#otherLevelNurse").hide();
                $("#moxing").show();
            }
            //宠物造型师&国际宠物美容师认证
            if (showCategory == '3') {
                $("#otherLevelO").hide();
                $("#otherLevelT").hide();
                $("#otherLevelR").show();
                $("#otherLevelNurse").hide();
            }
            //国际宠物洗护师
            if (showCategory == '4') {
                $("#otherLevelO").hide();
                $("#otherLevelT").hide();
                $("#otherLevelR").hide();
                $("#otherLevelNurse").show();
            }
            var showLevel = '${groomerRegister.showLevel}';
            var words = showLevel.split(",");
            if (showCategory == '1') {
                words.forEach(function (index, item) {
                    $("input[type=checkbox][name='showLevel'][value='" + index + "']").attr("checked", 'checked');
                });
            }
            //国际宠物美容师认证
            if (showCategory == '2') {
                words.forEach(function (index, item) {
                    $("#otherLevelT [type=checkbox][name='showLevel'][value='" + index + "']").attr("checked", 'checked');
                });
            }
            //宠物造型师&国际宠物美容师认证
            if (showCategory == '3') {
                words.forEach(function (index, item) {
                    $("#otherLevelR [type=checkbox][name='showLevel'][value='" + index + "']").attr("checked", 'checked');
                });
            }
            //宠物造型师&国际宠物美容师认证
            if (showCategory == '4') {
                words.forEach(function (index, item) {
                    $("#otherLevelNurse [type=radio][name='showLevel'][value='" + index + "']").attr("checked", 'checked');
                });
            }
        });

        function viewExamRecords(id) {
            parent.layer.open({
                type: 2,
                title: ['试题记录', 'font-size:18px;text-align: left;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['1000px', '540px'],
                content: "${ctx}/groomer/groomerWrittenExamInfo/gradeWriteDetail?id=" + id
            });
        }

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
    <!-- 悬浮提示插件 -->
    <link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
<ul class="nav nav-tabs">
    <li>
        <shiro:hasPermission name="groomer:groomerRegister:view">
            <a href="${ctx}/groomer/groomerRegister/view?id=${groomerRegister.id}">报名信息查看</a>
        </shiro:hasPermission>
    </li>
    <li class="active">
        <shiro:hasPermission name="groomer:groomerRegister:edit">
            <a href="${ctx}/groomer/groomerWrittenExamInfo/gradeDetail?id=${groomerRegister.id}">成绩查看</a>
        </shiro:hasPermission>
    </li>
</ul>
<form:form id="inputForm" modelAttribute="groomerRegisterVO" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <h4>实操成绩</h4>
    <div class="control-group">
        <label class="control-label">实操成绩:</label>
        <div class="controls">
                ${fns:getDictLabel(groomerRegisterVO.grade, 'Grade', '')}
        </div>
    </div>
    <div style="clear:both;"></div>
    <c:if test="${not empty groomerRegisterVO.groomerWrittenExamInfoList}">
        <h4>笔试成绩</h4>
        <table id="contentTable" class="table table-striped table-bordered table-condensed">
            <thead>
            <tr>
                <th>活动名称</th>
                <th>活动分类</th>
                <th>赛事级别</th>
                <th>分数</th>
                <th>状态</th>
                <th>考试开始时间</th>
                <th>试卷提交时间</th>
                <th>备注</th>
                <th>操作</th>
            </tr>
            </thead>
            <tbody>
            <c:forEach items="${groomerRegisterVO.groomerWrittenExamInfoList}" var="groomerWrittenExamInfo" varStatus="status">
                <tr>
                    <td>
                            ${fns:escapeHtml(groomerRegisterVO.groomerShow.showName)}
                    </td>
                    <td>
                            ${fns:getDictLabel(groomerRegisterVO.showCategory, 'groomer_show_category', '')}
                    </td>
                    <td>
                            ${fns:escapeHtml(groomerRegisterVO.showLevel)}
                    </td>
                    <td>
                        <c:if test="${not empty groomerWrittenExamInfo.gradeWrite}">
                            ${fns:escapeHtml(groomerWrittenExamInfo.gradeWrite)}
                        </c:if>
                    </td>
                    <td>
                        <c:if test="${groomerWrittenExamInfo.writtenExamStatus==0}">未通过</c:if>
                        <c:if test="${groomerWrittenExamInfo.writtenExamStatus==1}">通过</c:if>
                    </td>
                    <td>
                        <fmt:formatDate value="${groomerWrittenExamInfo.startExamTime}" pattern="yyyy-MM-dd HH:mm"/>
                    </td>
                    <td>
                        <c:choose>
                            <c:when test="${groomerWrittenExamInfo.commitExamType == 1}">
                                <fmt:formatDate value="${groomerWrittenExamInfo.endExamTime}" pattern="yyyy-MM-dd HH:mm"/>
                            </c:when>

                            <c:when test="${groomerWrittenExamInfo.commitExamType == 2}">
                                <fmt:formatDate value="${groomerWrittenExamInfo.lastSelectedTime}" pattern="yyyy-MM-dd HH:mm"/>
                            </c:when>

                            <c:when test="${groomerWrittenExamInfo.commitExamType == 3}">
                                <fmt:formatDate value="${groomerWrittenExamInfo.autoCloseTime}" pattern="yyyy-MM-dd HH:mm"/>
                            </c:when>
                        </c:choose>
                    </td>
                    <td>
                            ${fns:escapeHtml(groomerWrittenExamInfo.remarks)}
                    </td>
                    <td>
                        <shiro:hasPermission name="groomer:groomerRegister:view">
                            <a href="javascript:;"
                               onclick="viewExamRecords('${fns:escapeHtml(groomerWrittenExamInfo.id)}')">查看</a>
                        </shiro:hasPermission>
                        <c:if test="${(groomerWrittenExamInfo.writtenExamStatus == null
                        || groomerWrittenExamInfo.writtenExamStatus == ''
                        || groomerWrittenExamInfo.writtenExamStatus == '0' )
                        && groomerWrittenExamInfo.startExamTime != null && !groomerRegisterVO.eligibility && status.index == 0}">
                            <shiro:hasPermission name="groomer:groomerRegister:edit">
                                <a href="${ctx}/groomer/groomerWrittenExamInfo/reset?id=${fns:escapeHtml(groomerWrittenExamInfo.id)}"
                                   onclick="return confirmx('是否确定重置笔试考试状态？', this.href)">重置</a>
                            </shiro:hasPermission>
                        </c:if>
                    </td>
                </tr>
            </c:forEach>
            </tbody>
        </table>
    </c:if>
    <div class="form-actions">
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
<div class="pagination">${page}</div>
</body>
</html>