<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/clubdog/clubDog/">淘宠犬只鉴定列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="clubDog" action="${ctx}/clubdog/clubDog/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>鉴定证书号：</label>
				<form:input path="pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬主人：</label>
				<form:input path="dogOwner" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬种：</label>
                <form:select id="dogBreed" path="dogBreed" class="input-xlarge" >
                	<form:option value="" label="请选择犬种"/>
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode"  htmlEscape="false"/>
                </form:select>
             </li>
			<li><label>芯片号：</label>
				<form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>鉴定证书号</th>
				<th>犬主人</th>
				<th>会员号</th>
				<th>英文姓名</th>
				<th>芯片号</th>
				<th>犬种</th>
				<th>创建时间</th>
				<th>备注信息</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="clubDog">
			<tr>
				<td><a href="${ctx}/clubdog/clubDog/form?id=${clubDog.id}">
					${clubDog.pedigreeCertifiedCode}
				</a></td>
				<td>
					${clubDog.dogOwner}
				</td>
				<td>
					${clubDog.memberCode}
				</td>
				<td>
					${clubDog.nameEn}
				</td>
				<td>
					${clubDog.identificationFlag}
				</td>
				<td>
					${clubDog.dogBreed}
				</td>
				<td>
					<fmt:formatDate value="${clubDog.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${clubDog.remarks}
				</td>
				<td>
					<shiro:hasPermission name="clubdog:clubDog:view">
    				<a href="${ctx}/clubdog/clubDog/viewForm?id=${clubDog.id}">查看</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="clubdog:clubDog:edit">
    				<a href="${ctx}/clubdog/clubDog/form?id=${clubDog.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="clubdog:clubDog:delete">
					<a href="${ctx}/clubdog/clubDog/delete?id=${clubDog.id}" onclick="return confirmx('确认要删除该犬只信息吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>