package com.cku.restful.v1.sys.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import net.sf.json.JSONObject;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.Remind;
import com.cku.oa.sys.service.RemindService;
import com.cku.restful.v1.sys.model.RestOaNotify;
import com.cku.restful.v1.sys.model.RestRemind;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.oa.dao.OaNotifyRecordDao;
import com.thinkgem.jeesite.modules.oa.entity.OaNotify;
import com.thinkgem.jeesite.modules.oa.entity.OaNotifyRecord;
import com.thinkgem.jeesite.modules.oa.service.OaNotifyService;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 业务提醒功能Service
 * 
 * @author fanhuibin
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class RestRemindService {
	@Autowired
	private RemindService remindService;
	@Autowired
	private OaNotifyService oaNotifyService;
	@Autowired
	private OaNotifyRecordDao oaNotifyRecordDao;

	@Transactional(readOnly = false)
	public RESTResponse getRemindList(HttpServletRequest request) {
		// 获取参数
		String content = request.getParameter("content");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 5;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"pageNo和pageSize必须都为数字");
		}

		Remind example = new Remind();
		// 设置分页参数
		Page<Remind> page = new Page<Remind>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setUser(UserUtils.getLoginUser());
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(content)) {
			example.setContent(content);
		}

		// 查询并组装返回对象
		Page<Remind> result = remindService.findPage(page, example);
		List<Remind> remindList = result.getList();
		List<RestRemind> list = new ArrayList<RestRemind>();
		for (Remind remind : remindList) {
			RestRemind vo = new RestRemind();
			BeanUtil.copyProperties(vo, remind, "yyyy-MM-dd HH:mm");
			list.add(vo);
		}
		long count = result.getCount();

		// 标记消息为已读
		remindService.updateReadFlag();

		return new RESTResponse("list", new PageBeanResult<RestRemind>(list,count));
	}
	
	public RESTResponse getNotifyList(HttpServletRequest request) {
		// 获取参数
		String title = request.getParameter("title");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 5;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"pageNo和pageSize必须都为数字");
		}
		
		OaNotify example = new OaNotify();
		// 设置分页参数
		Page<OaNotify> page = new Page<OaNotify>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(title)) {
			example.setTitle(title);
		}
		
		// 查询并组装返回对象
		Page<OaNotify> result = oaNotifyService.findPage(page, example);
		List<OaNotify> oaNotifyList = result.getList();
		List<RestOaNotify> list = new ArrayList<RestOaNotify>();
		String userId = UserUtils.getLoginUser().getId();
		for (OaNotify oaNotify : oaNotifyList) {
			RestOaNotify vo = new RestOaNotify();
			BeanUtil.copyProperties(vo, oaNotify, "yyyy-MM-dd HH:mm");
			String readFlag = "0";
			int count = oaNotifyRecordDao.countByOaNotifyIdAndUserId(oaNotify.getId(), userId);
			if(count>0){
				readFlag = "1";
			}
			vo.setReadFlag(readFlag);
			list.add(vo);
		}
		long count = oaNotifyService.findCount(example);
		return new RESTResponse("list", new PageBeanResult<RestOaNotify>(list,count));
	}
	
	@Transactional(readOnly = false)
	public RESTResponse putNotify(String json){
		//获取参数
		OaNotify vo = BeanUtil.toBean(json, OaNotify.class);
		OaNotify oaNotify = oaNotifyService.get(vo.getId());
		if(oaNotify!=null){
			User user = UserUtils.getLoginUser();
			int count = oaNotifyRecordDao.countByOaNotifyIdAndUserId(oaNotify.getId(), user.getId());
			if(count==0){
				OaNotifyRecord oaNotifyRecord = new OaNotifyRecord();
				oaNotifyRecord.setId(IdGen.uuid());
				oaNotifyRecord.setOaNotify(oaNotify);
				oaNotifyRecord.setUser(user);
				oaNotifyRecord.setReadFlag("1");
				oaNotifyRecord.setReadDate(new Date());
				oaNotifyRecordDao.insert(oaNotifyRecord);
			}
		}
		return new RESTResponse();
	}
	
	/**
	 * 
	 * @description: 获取业务消息和系统消息条数
	 * @author: laiguanglong
	 * @date: 2016年10月14日 下午5:05:53
	 */
	public RESTResponse getCount(){
		JSONObject jo = new JSONObject();
		Remind example1 = new Remind();
		Page<Remind> page1 = new Page<Remind>();
		page1.setPageNo(1);
		page1.setPageSize(1);
		example1.setUser(UserUtils.getLoginUser());
		example1.setDelFlag("0");
		example1.setPage(page1);
		Page<Remind> result1 = remindService.findPage(page1, example1);
		long remindCount = result1.getCount();
		jo.put("remindCount", remindCount);
		OaNotify example2 = new OaNotify();
		// 设置分页参数
		Page<OaNotify> page2 = new Page<OaNotify>();
		page2.setPageNo(1);
		page2.setPageSize(1);
		// 设置查询条件
		example2.setDelFlag("0");
		example2.setPage(page2);
		Page<OaNotify> result2 = oaNotifyService.findPage(page2, example2);
		long notifyCount = result2.getCount();
		jo.put("notifyCount", notifyCount);
		return new RESTResponse(jo);
	}
}