package com.cku.restful.v1.sys.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.Appraiser;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.AppraiserService;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.util.FnsUtils;
import com.cku.oa.sys.util.Img2Base64Util;
import com.cku.restful.v1.sys.model.RestAppraiser;

/**
 * 鉴定师表Service
 * @author zhangjunwu
 * @version 2019-10-16
 */
@Service
@Transactional(readOnly = true)
public class RestAppraiserService{

	@Autowired
	private AppraiserService appraiserService;
	
	@Autowired
	private FileService fileService;
	
	private final static SimpleDateFormat SDF_YMD = new SimpleDateFormat("yyyy-MM-dd");
	
	public RESTResponse getAppraiser(String id) {
		Appraiser appraiser = appraiserService.get(id);
		if(appraiser == null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "未能找到该认证师");
		}
		RestAppraiser rest = new RestAppraiser();
		rest.setId(id);
		rest.setName(appraiser.getName());
		rest.setNameEn(appraiser.getNameEn());
		rest.setCertificateNum(appraiser.getCertificateNum());
		rest.setMobile(appraiser.getMobile());
		rest.setProvince(appraiser.getProvince());
		rest.setCity(appraiser.getCity());
		rest.setStreet(appraiser.getStreet());
		Org org = FnsUtils.getOrgById(appraiser.getOrgId());
		rest.setOrgName(org.getName());
		rest.setOrgAddress(org.getAddress());
		rest.setOrgCode(org.getMemberCode());
		rest.setEndDate(org.getEndDate()==null?"":SDF_YMD.format(org.getEndDate()));
		
		ByteArrayOutputStream outPut = null;
		try {
			BaseFile file = fileService.get(appraiser.getPhoto());
			if(file != null) {
				outPut = new ByteArrayOutputStream();
				fileService.fileDownload(file,outPut);
				rest.setPhotoImg(Img2Base64Util.getImgStr(outPut.toByteArray()));
				rest.setPhotoImgType(file.getExtension());
				rest.setPhotoImgExtension(file.getType());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
			try {
				if(outPut != null)
				outPut.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		
        return new RESTResponse("data",rest);
	}
	
}