/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.groomer.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.service.RestGroomerDiplomaService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 美容师结业证书Controller
 * @author cxt
 * @version 2016-07-15
 */
@Controller
@RequestMapping(value = "/api/v1/groomer")
public class RestGroomerDiplomaController extends BaseRestController {

	@Autowired
	private RestGroomerDiplomaService restGroomerDiplomaService;
	
	@RequestMapping(value = "/groomerDiploma", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restGroomerDiplomaService.post(json);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 结业证书列表
	 * @Author chaixueteng
	 * @2016年9月25日下午3:02:22
	 */
	@RequestMapping(value = "/getGroomerDiplomaList", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restGroomerDiplomaService.getList(request);
		ServletUtils.writeResponse(response, result);
	}
	
	@RequestMapping(value = "/groomerDiploma/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void delete(@PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restGroomerDiplomaService.delete(id);
		ServletUtils.writeResponse(response, result);
	}
	
}