package com.cku.restful.v1.dogNoseprin.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.restful.v1.dogNoseprin.dao.DogPrizePoolDao;
import com.cku.restful.v1.dogNoseprin.entity.DogPrizePool;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 奖池设置表Service
 * 
 * @author xx
 * @version 2020-05-07
 */
@Service
@Transactional(readOnly = true)
public class DogPrizePoolService extends CrudService<DogPrizePoolDao, DogPrizePool> {

	public DogPrizePool get(String id) {
		return super.get(id);
	}

	public List<DogPrizePool> findList(DogPrizePool dogPrizePool) {
		return super.findList(dogPrizePool);
	}

	public Page<DogPrizePool> findPage(Page<DogPrizePool> page, DogPrizePool dogPrizePool) {
		return super.findPage(page, dogPrizePool);
	}

	@Transactional(readOnly = false)
	public void save(DogPrizePool dogPrizePool) {
		super.save(dogPrizePool);
	}

	@Transactional(readOnly = false)
	public void delete(DogPrizePool dogPrizePool) {
		super.delete(dogPrizePool);
	}

	public List<DogPrizePool> findListByPoolCode(String poolCode) {
		return dao.findListByPoolCode(poolCode);
	}

	public DogPrizePool getByPrizeName(String poolCode, String prizeName) {
		return dao.getByPrizeName(poolCode, prizeName);
	}

	public int deduct(String id, Integer num) {
		return dao.deduct(id, num);
	}

}