package com.cku.restful.v1;

import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
 
public class YearWeeksUtil {
    public static void main(String[] args) {
 
        String endtime = getYearEnd();
        System.out.println(endtime);
        //String currentYear = getCurrentYear();
        //getWeekRangeMap(2021,53);
        //getYearWeekMap(2021);
        String retval = getMonthStart(2021,2);
        System.out.println(retval);
        retval = getMonthEnd(2021,2);
        System.out.println(retval);
    }
 
 
 
    /**
     * 获取当前年
     * @return
     */
    private static String getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        int weekYear = calendar.get(Calendar.YEAR);//获得当前的年
        return weekYear+"";
    }
 
    /**
     * 获取今天
     * @return String
     * */
    public static String getToday(){
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }
    /**
     * 获取昨天
     * @return String
     * */
    public static String getYestoday(){
        Calendar cal=Calendar.getInstance();
        cal.add(Calendar.DATE,-1);
        Date time=cal.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(time);
    }
    /**
     * 获取本月开始日期
     * @return String
     * **/
    public static String getMonthStart(){
        Calendar cal=Calendar.getInstance();
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        Date time=cal.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(time)+" 00:00:00";
    }
    /**
     * 获取某年某月开始日期
     * @return String
     * **/
    public static String getMonthStart(int year,int month){
        Calendar cal=Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month-1);
        cal.set(Calendar.DAY_OF_MONTH, 1);
        Date time=cal.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(time)+" 00:00:00";
    }
    /**
     * 获取本月最后一天
     * @return String
     * **/
    public static String getMonthEnd(){
        Calendar cal=Calendar.getInstance();
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date time=cal.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(time)+" 23:59:59";
    }
 
    /**
     * 获取某年某月最后一天
     * @return String
     * **/
    public static String getMonthEnd(int year,int month){
        Calendar cal=Calendar.getInstance();
        cal.set(Calendar.YEAR, year);
        cal.set(Calendar.MONTH, month-1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date time=cal.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(time)+" 23:59:59";
    }
    /**
     * 获取本周的第一天
     * @return String
     * **/
    public static String getWeekStart(){
        Calendar cal=Calendar.getInstance();
        cal.add(Calendar.WEEK_OF_MONTH, 0);
        cal.set(Calendar.DAY_OF_WEEK, 2);
        Date time=cal.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(time)+" 00:00:00";
    }
    /**
     * 获取本周的最后一天
     * @return String
     * **/
    public static String getWeekEnd(){
        Calendar cal=Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, cal.getActualMaximum(Calendar.DAY_OF_WEEK));
        cal.add(Calendar.DAY_OF_WEEK, 1);
        Date time=cal.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(time)+" 23:59:59";
    }
    /**
     * 获取本年的第一天
     * @return String
     * **/
    public static String getYearStart(){
        return new SimpleDateFormat("yyyy").format(new Date())+"-01-01 00:00:00";
    }
 
    /**
     * 获取某年的第一天
     * @return String
     * **/
    public static String getYearStart(int year){
        return year+"-01-01 00:00:00";
    }
 
    /**
     * 获取本年的最后一天
     * @return String
     * **/
    public static String getYearEnd(){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH,calendar.getActualMaximum(Calendar.MONTH));
        calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date currYearLast = calendar.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(currYearLast)+" 23:59:59";
    }
 
    /**
     * 获取某年的最后一天
     * @return String
     * **/
    public static String getYearEnd(int year){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR,year);
        calendar.set(Calendar.MONTH,calendar.getActualMaximum(Calendar.MONTH));
        calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        Date currYearLast = calendar.getTime();
        return new SimpleDateFormat("yyyy-MM-dd").format(currYearLast)+" 23:59:59";
    }
 
    /**
     * 获取某年某周的时间跨度
     * @param year
     * @param week
     * @return
     */
    public static Map<String, String> getWeekRangeMap(int year, int week) {
        Map<String, String> timeMap = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR,year);
        calendar.setFirstDayOfWeek(Calendar.MONDAY);//设置星期一为一周开始的第一天
        calendar.setMinimalDaysInFirstWeek(4);//可以不用设置
        int weekYear = calendar.get(Calendar.YEAR);//获得当前的年
        calendar.setWeekDate(weekYear, week, 2);//获得指定年的第几周的开始日期
        Date time=calendar.getTime();
        String startTime = new SimpleDateFormat("yyyy-MM-dd").format(time)+" 00:00:00";
        timeMap.put("startTime",startTime);
        calendar.setWeekDate(weekYear, week, 1);//获得指定年的第几周的结束日期
        time=calendar.getTime();
        String endTime = new SimpleDateFormat("yyyy-MM-dd").format(time)+" 23:59:59";
        timeMap.put("endTime",endTime);
        return timeMap;
    }
 
    /**
     * 获取某年有多少周
     * @param year
     * @return
     * @throws ParseException
     */
    public static int getYearWeekConut(int year){
        int week = 52;
        try {
            /*Calendar calendar = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            calendar.setFirstDayOfWeek(Calendar.MONDAY);//设置星期一为一周开始的第一天
            calendar.set(year, Calendar.DECEMBER, 31, 23, 59, 59);
            week = calendar.get(Calendar.WEEK_OF_YEAR);*/
            Map<String, String> timeMap = getWeekRangeMap(year,53);
            if(!CollectionUtils.isEmpty(timeMap)){
                String startTime = timeMap.get("startTime");
                if(startTime.substring(0, 4).equals(year+"")){ //判断年度是否相符，如果相符说明有53个周。
                    week = 53;
                }
            }
        } catch (Exception e) {
           e.printStackTrace();
        }
 
        return week;
    }
 
    /**
     * 获取某年所有周的时间跨度
     * @param year
     * @return
     */
    public static Map<String, Map<String, String>> getYearWeekMap(int year) {
        int weeks = getYearWeekConut(year);
        Map<String, Map<String, String>> yearWeekMap = new HashMap<String, Map<String, String>>();
        for (int i =1;i<=weeks;i++){
            Map<String, String> timeMap = getWeekRangeMap(year,i);
            yearWeekMap.put(i+"",timeMap);
        }
        return yearWeekMap;
    }
}