/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 俱乐部打印重置Entity
 * @author cxt
 * @version 2017-10-24
 */
public class SysOrgPrint extends DataEntity<SysOrgPrint> {
	
	private static final long serialVersionUID = 1L;
	private String orgId;		// 俱乐部id
	private String orgCode;		// 俱乐部会员号
	private Date validDate;		// 计算时间
	private String restPrintCode;		// 重置次数
	
	public SysOrgPrint() {
		super();
	}

	public SysOrgPrint(String id){
		super(id);
	}

	@Length(min=1, max=64, message="俱乐部id长度必须介于 1 和 64 之间")
	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}
	
	@Length(min=0, max=50, message="俱乐部会员号长度必须介于 0 和 50 之间")
	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getValidDate() {
		return validDate;
	}

	public void setValidDate(Date validDate) {
		this.validDate = validDate;
	}
	
	@Length(min=0, max=11, message="重置次数长度必须介于 0 和 11 之间")
	public String getRestPrintCode() {
		return restPrintCode;
	}

	public void setRestPrintCode(String restPrintCode) {
		this.restPrintCode = restPrintCode;
	}
	
}