/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao.user;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sys.entity.user.CabSysUser;
import com.cku.oa.sys.entity.user.CabSysUserThirdRef;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

@MyBatisDao
public interface CabSysUserThirdRefDao extends CrudDao<CabSysUserThirdRef> {
	
	CabSysUserThirdRef selectByThirdId(@Param("thirdId") String thirdId);
	
	List<CabSysUserThirdRef> selectByThirdIds(@Param("thirdIds") List<String> thirdIds);
	
	List<CabSysUserThirdRef> selectAllByThirdId(@Param("thirdId") String thirdId);
	
	List<CabSysUserThirdRef> selectAllByUserId(@Param("userId") String userId);
	
	int deleteByThirdId(@Param("thirdId")String thirdId);
	
	int deleteUserById(@Param("userId")String userId);
	
	CabSysUser selectByMobile(@Param("mobile") String mobile);
	
	CabSysUser selectUserByThirdId(@Param("thirdId") String thirdId);
	
	int insertThirdRef(@Param("entity") CabSysUserThirdRef entity);
	
	int insertSysUser(@Param("entity") CabSysUser entity);
	
	int updateSysUser(@Param("entity") CabSysUser entity);
	
	int updateSysUserAuthentication(@Param("entity") CabSysUser entity);

}