/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import com.cku.oa.sys.entity.Org;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 合作机构、合作医院DAO接口
 * @author fanhuibin
 * @version 2016-08-22
 */
@MyBatisDao
public interface OrgDao extends CrudDao<Org> {

	/**
	 * 通过会员号查询合作机构，不包括已经删除的
	 * @param memberCode
	 * @return
	 */
    Org getOrgByMemberCode(@Param("memberCode")String memberCode);

    /**
     * 通过会员号查询合作机构，包括已经删除的
     * @param memberCode
     * @return
     */
    Org getALLOrgByMemberCode(@Param("memberCode")String memberCode);
    //修改地址
	void updateAddress(Org org);

	void updateAdminCode(Org org);

	/**
	 *
	 * @Description：根据芯片号获取上传该芯片的合作机构名称
	 * @author: zhuoHeng
	 * @version: 2017年1月4日 下午3:12:46
	 */
	List<Org> getClubNameByChip(@Param("chip") String chip);

    //根据城市模糊查询地址，根据关键字模糊查询名称，只查俱乐部类型的机构
    List<Org> getByCityAndKey(@Param("city")String city,@Param("key")String key);

    /**
     * 根据userid 查询地方机构信息
     * @return
     */
    Org getOrgByUserId(@Param("userId")String userId);

    Org findByUserId(@Param("userId")String userId);
    /**
     * @description: CKU官网查询合作机构接口方法
     * @author: laiguanglong
     * @date: 2017/7/14 10:22
     */
    List<Org> getOrg(@Param("orgType") String orgType, @Param("province") String province,@Param("orgSite") String orgSite, @Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);
	/**
	* @Description:  CKU官网查询合作机构接口方法 记录条数
	* @author: zhangxiang
	* @date: 2019/10/24 9:53
	*/
    List<Org> getOrgList(@Param("orgType") String orgType, @Param("province") String province,@Param("orgSite") String orgSite);

    Long getOrgCount(@Param("orgType") String orgType, @Param("province") String province);

	List<Org> findProvince(@Param("orgType") String orgType);

	Org selectByOrgId(@Param("orgId") String orgId);

	List<Org> findAll();

	int updateDogNoseEdit(@Param("memberCode") String memberCode,
						  @Param("dogNoseRepeatedDetection") String dogNoseRepeatedDetection,
						  @Param("dogNoseLivenessDetection") String dogNoseLivenessDetection);
}