/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.coupon.dao;

import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.entity.UserCouponCompose;
import com.cku.oa.sys.coupon.vo.CouponGroupVO;
import com.cku.oa.sys.coupon.vo.SysCouponEntityVO;
import com.cku.restful.v1.sys.model.RestCouponCompose;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 优惠劵DAO接口
 * 
 * @author 柴雪腾
 * @version 2018-04-12
 */
@MyBatisDao
public interface SysCouponDao extends CrudDao<SysCoupon> {

	// 查询优惠劵可用的
	List<SysCoupon> findCouponList(@Param("memberCode") String memberCode, @Param("state") String state);

	void updateMemberCode(SysCoupon sysCoupon);

	void refundCoupon(@Param("vo") SysCoupon vo, @Param("targetIds") Set<String> targetIds);

	// 查询优惠劵数量
	String findCouponCount(@Param("memberCode") String memberCode, @Param("state") String state);

	/**
	 * 根据会员号、适用对象、是否使用查询优惠券
	 * 
	 * @param memberCode
	 * @param state
	 * @param target
	 * @return
	 */
	List<SysCoupon> getCouponList(@Param("memberCode") String memberCode, @Param("state") String state,
			@Param("target") String target);
	
	List<SysCoupon> getByGroupId(@Param("groupId") String groupId);

	List<SysCoupon> getByTargetId(@Param("targetId") String targetId);

	List<SysCouponEntityVO> findAvailableListCouponList(@Param("memberCode") String memberCode);

	List<SysCoupon> findCouponListByTarget(@Param("memberCode") String memberCode, @Param("state") String state,
			@Param("target") String target);

	List<SysCoupon> getCouponXNList(@Param("orderCode") String orderCode);

	List<SysCoupon> getListByCouponDefId(@Param("ids") String[] ids);

	void refundCouponById(@Param("coupon") SysCoupon coupon, @Param("targetIds") Set<String> targetIds);

	/**
	 * 查询优惠包列表
	 */
	List<RestCouponCompose> composeList(@Param("composeType")String composeType);
	/**
	 * 保存购包记录
	 */
	void saveCouponCompose(@Param("vo") UserCouponCompose vo);
	
	/**
	 * 根据id查询优惠包
	 */
	RestCouponCompose getComposeById(@Param("id")String id);
	
	/**
	 * 查询用户购买记录
	 */
	UserCouponCompose getUserComposeById(@Param("id") String id);

	/**
	 * 分组显示列表
	 * @param entity
	 * @return
	 */
	List<CouponGroupVO> findGroupList(SysCoupon entity);
	
	

	List<SysCoupon> getListByIds(@Param("memberCode") String memberCode,@Param("ids") List<String> ids);
	
	Integer findExpireNum(SysCoupon sysCoupon);
}