package com.cku.oa.show.web;

import com.cku.oa.show.entity.CkuMatchRule;
import com.cku.oa.show.service.CkuMatchRuleService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 犬展规范Controller
 * @author wj
 * @version 2020-07-10
 */
@Controller
@RequestMapping(value = "${adminPath}/show/ckuMatchRule")
public class CkuMatchRuleController extends BaseController {

	@Autowired
	private CkuMatchRuleService ckuMatchRuleService;

	@ModelAttribute
	public CkuMatchRule get(@RequestParam(required=false) String id) {
		CkuMatchRule entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = ckuMatchRuleService.get(id);
		}
		if (entity == null){
			entity = new CkuMatchRule();
		}
		return entity;
	}

	@RequiresPermissions("show:ckuMatchRule:view")
	@RequestMapping(value = {"list", ""})
	public String list(CkuMatchRule ckuMatchRule, HttpServletRequest request, HttpServletResponse response, Model model) {
		if (StringUtils.isNotBlank(ckuMatchRule.getRuleInfo())) {
			ckuMatchRule.setRuleInfo(StringEscapeUtils.unescapeHtml4(ckuMatchRule.getRuleInfo()));
		}
		if(StringUtils.isNotBlank(ckuMatchRule.getType())){
			ckuMatchRule.setType(ckuMatchRule.getType()+",");
		}
		Page<CkuMatchRule> page = ckuMatchRuleService.findPage(new Page<CkuMatchRule>(request, response), ckuMatchRule);
		List<CkuMatchRule> list = page.getList().stream().map(data -> {
			if(StringUtils.isNotBlank(data.getType())){
				data.setType(data.getType().replace(","," ").toUpperCase());
			}
			return  data;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		if(StringUtils.isNotBlank(ckuMatchRule.getType())){
			ckuMatchRule.setType(ckuMatchRule.getType().split(",")[0]);
		}
		model.addAttribute("ckuMatchRule", ckuMatchRule);
		return "oa/show/matchRule/ckuMatchRuleList";
	}

	@RequiresPermissions("show:ckuMatchRule:view")
	@RequestMapping(value = "form")
	public String form(CkuMatchRule ckuMatchRule, Model model) {
		if(StringUtils.isNotBlank(ckuMatchRule.getType())){
			ckuMatchRule.setTypeArr(ckuMatchRule.getType().split(","));
		}
		model.addAttribute("ckuMatchRule", ckuMatchRule);
		return "oa/show/matchRule/ckuMatchRuleForm";
	}

	@RequiresPermissions("show:ckuMatchRule:edit")
	@RequestMapping(value = "save")
	public String save(CkuMatchRule ckuMatchRule, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, ckuMatchRule)){
			return form(ckuMatchRule, model);
		}
		ckuMatchRuleService.saveCkuMatchRule(ckuMatchRule);
		addMessage(redirectAttributes, "保存犬展规范成功");
		return "redirect:"+Global.getAdminPath()+"/show/ckuMatchRule/?repage";
	}

	@RequiresPermissions("show:ckuMatchRule:edit")
	@RequestMapping(value = "delete")
	public String delete(CkuMatchRule ckuMatchRule, RedirectAttributes redirectAttributes) {
		ckuMatchRuleService.delete(ckuMatchRule);
		addMessage(redirectAttributes, "删除犬展规范成功");
		return "redirect:"+Global.getAdminPath()+"/show/ckuMatchRule/?repage";
	}

}