/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛事积分Entity
 * @author lgl
 * @version 2016-07-12
 */
public class ShowScore extends DataEntity<ShowScore> {
	
	private static final long serialVersionUID = 1L;
	@Length(min=4, max=4, message="年份长度必须为4位")
	private String year;		// 年份
	@NotBlank(message="积分类型不能为空")
	private String scoreType;		// 积分类型(BIS成犬;PBIS幼犬)
	@NotBlank(message="积分不能为空")
	private String score;		// 积分
	@NotBlank(message="血统证书编号不能为空")
	private String pedigreeCertified;		// 血统证书编号
	@NotBlank(message="性别不能为空")
	private String dogGender;		// 性别
	@NotBlank(message="犬主人不能为空")
	private String dogOwner;		// 犬主人
	@NotBlank(message="犬种中文名不能为空")
	private String dogBreedNameCn;		// 犬种中文名
	@NotBlank(message="犬种英文名不能为空")
	private String dogBreedNameEn;		// 犬种英文名
	private String dogName;		// 犬名
	private String dogBreedGroup;		// 组别
	
	public String getDogBreedGroup() {
		return dogBreedGroup;
	}

	public void setDogBreedGroup(String dogBreedGroup) {
		this.dogBreedGroup = dogBreedGroup;
	}

	public ShowScore() {
		super();
	}

	public ShowScore(String id){
		super(id);
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}
	
	public String getScoreType() {
		return scoreType;
	}

	public void setScoreType(String scoreType) {
		this.scoreType = scoreType;
	}
	
	public String getScore() {
		return score;
	}

	public void setScore(String score) {
		this.score = score;
	}
	
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}
	
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}
	
	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}
	
	public String getDogBreedNameCn() {
		return dogBreedNameCn;
	}

	public void setDogBreedNameCn(String dogBreedNameCn) {
		this.dogBreedNameCn = dogBreedNameCn;
	}
	
	public String getDogBreedNameEn() {
		return dogBreedNameEn;
	}

	public void setDogBreedNameEn(String dogBreedNameEn) {
		this.dogBreedNameEn = dogBreedNameEn;
	}
	
	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}
	
}