/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import com.cku.oa.show.entity.ShowScore;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 赛事积分DAO接口
 *
 * @author lgl
 * @version 2016-07-12
 */
@MyBatisDao
public interface ShowScoreDao extends CrudDao<ShowScore> {
	/**
	 *
	 * @description: 赛事积分排名
	 * @author: laiguanglong
	 * @date: 2016年9月26日 上午11:16:11
	 */
	List<ShowScore> getScoreRank123(@Param("year") String year,
                                    @Param("scoreType") String scoreType,
                                    @Param("pedigreeCertified") String pedigreeCertified,
                                    @Param("pageSize") Integer pageSize,
                                    @Param("ageGroup") String ageGroup,
									@Param("pedigreeCertifiedList")List pedigreeCertifiedList);

	List<ShowScore> getScoreRank20(@Param("year") String year,
								   @Param("scoreType") String scoreType,
								   @Param("pedigreeCertified") String pedigreeCertified,
								   @Param("pageSize") Integer pageSize,
								   @Param("pedigreeCertifiedList")List pedigreeCertifiedList);

	List<ShowScore> getScoreRank30(@Param("year") String year,
			@Param("scoreType") String scoreType,
			@Param("pedigreeCertified") String pedigreeCertified,
			@Param("pageSize") Integer pageSize,
			@Param("ageGroup") String ageGroup);

	List<ShowScore> getScoreRank4(@Param("year") String year,
			@Param("scoreType") String scoreType,
			@Param("pedigreeCertified") String pedigreeCertified,
			@Param("pageSize") Integer pageSize,
			@Param("ageGroup") String ageGroup);

	List<ShowScore> getScoreRank678(@Param("year") String year,
			@Param("scoreType") String scoreType,
			@Param("pedigreeCertified") String pedigreeCertified,
			@Param("pageSize") Integer pageSize,
			@Param("ageGroup") String ageGroup);

	/**
	 *
	 * @description: 赛事积分排名单独展
	 * @author: laiguanglong
	 * @date: 2016年9月26日 上午11:16:11
	 */
	List<ShowScore> getScoreRankBov(@Param("year") String year,
			@Param("ageGroup") String ageGroup,
			@Param("pedigreeCertified") String pedigreeCertified,
			@Param("formatCode") Integer formatCode);

	/**
	 * @description: 根据血统证书号查询当年赛事成绩排名
	 * @author: laiguanglong
	 * @date: 2017/10/18 10:39
	 */
	String getRankByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);
	
	List<ShowScore> getScoreRankDZQ(@Param("year") String year);
	
	List<ShowScore> getScoreRank3(@Param("year") String year,
			@Param("pedigreeCertifiedList")List<String> pedigreeCertifiedList);
	
	List<ShowScore> getScoreRank12(@Param("year") String year,@Param("month") String month,@Param("scoreType") String scoreType);
	
	List<ShowScore> getScoreRankGroup(@Param("year") String year,
			@Param("pedigreeCertifiedList")List<String> pedigreeCertifiedList);
}