/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.show.entity.CkuImage;
import com.cku.oa.show.entity.MainShows;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 赛事主表DAO接口
 *
 * @author lgl
 * @version 2016-07-11
 */
@MyBatisDao
public interface MainShowsDao extends CrudDao<MainShows> {

	public List<MainShows> findAllMainShows();

	public List<MainShows> findUnCloseMainShows(
			@Param("showLocation") String showLocation,
			@Param("mainShowName") String mainShowName,
			@Param("closingTime") Date closingTime,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	public long countUnCloseMainShows(
			@Param("showLocation") String showLocation,
			@Param("mainShowName") String mainShowName,
			@Param("closingTime") Date closingTime);

	public List<MainShows> findDogAppraisalMainShows(
			@Param("showLocation") String showLocation,
			@Param("mainShowName") String mainShowName,
			@Param("SHOW_APPRAISAL_BEFORE_DAY") Integer SHOW_APPRAISAL_BEFORE_DAY,
			@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	public long countDogAppraisalMainShows(
			@Param("showLocation") String showLocation,
			@Param("mainShowName") String mainShowName,
			@Param("SHOW_APPRAISAL_BEFORE_DAY") Integer SHOW_APPRAISAL_BEFORE_DAY);

	public List<MainShows> findCloseMainShows(@Param("year") String year,@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	public long countCloseMainShows(@Param("year") String year);

	public List<MainShows> getMainShows();

	/**
	 *
	 * @description: 把已过赛事报名时间的赛事标记为关闭报名状态
	 * @author: laiguanglong
	 * @date: 2016年10月31日 下午2:52:57
	 */
	int updateRegisterFlag();

	/**
	 * @description: 根据赛事编号前缀关联子赛事查询主赛事记录
	 * @author: laiguanglong
	 * @date: 2017/3/30 16:27
	 */
	MainShows getByShowCodePrefix(@Param("showCodePrefix")String showCodePrefix);

	/**
	 * @description: 获取最近结束的主赛事信息
	 * @author: laiguanglong
	 * @date: 2017/6/7 14:09
	 */
	List<MainShows> getLatestEnd();
	/**
	 * @description: 获取未结束主赛事信息
	 * @author: laiguanglong
	 * @date: 2017/8/24 14:48
	 */
	List<MainShows> findUnEndMainShows(@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);
	/**
	 * @description: 获取未结束主赛事记录条数
	 * @author: laiguanglong
	 * @date: 2017/8/24 14:48
	 */
	long countUnEndMainShows();

	/**
	 * 删除赛事图片
	 * @Author chaixueteng
	 * @2017年8月28日上午10:39:37
	 */
	public void deleteImage(MainShows mainShows);

	List<MainShows> findAllEndShow();
	/**
	 * 批量处理赛事状态
	 * @param list
	 * @return
	 */
	int updateShowStatus(List<MainShows> list);

	CkuImage getCkuImage(@Param("remarks") String remarks);
	
	int updateCkuImage(@Param("ckuImage") CkuImage ckuImage);
	
	int insertCkuImage(@Param("ckuImage") CkuImage ckuImage);
	
}