package com.cku.oa.shop.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.shop.entity.ShopCarts;
import com.cku.oa.shop.service.ShopCartsService;

/**
 * 商城购物车临时Controller
 * @author lyy
 * @version 2016-08-23
 */
@Controller
@RequestMapping(value = "${adminPath}/shop/shopCarts")
public class ShopCartsController extends BaseController {

	@Autowired
	private ShopCartsService shopCartsService;
	
	@ModelAttribute
	public ShopCarts get(@RequestParam(required=false) String id) {
		ShopCarts entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = shopCartsService.get(id);
		}
		if (entity == null){
			entity = new ShopCarts();
		}
		return entity;
	}
	
	@RequiresPermissions("shop:shopCarts:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShopCarts shopCarts, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShopCarts> page = shopCartsService.findPage(new Page<ShopCarts>(request, response), shopCarts); 
		model.addAttribute("page", page);
		return "oa/shop/shopCartsList";
	}

	@RequiresPermissions("shop:shopCarts:view")
	@RequestMapping(value = "form")
	public String form(ShopCarts shopCarts, Model model) {
		model.addAttribute("shopCarts", shopCarts);
		return "oa/shop/shopCartsForm";
	}

	@RequiresPermissions("shop:shopCarts:add")
	@RequestMapping(value = "save")
	public String save(ShopCarts shopCarts, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, shopCarts)){
			return form(shopCarts, model);
		}
		shopCartsService.save(shopCarts,null);
		return "redirect:"+Global.getAdminPath()+"/shop/shopOrder/form?memberCode="+shopCarts.getMemberCode();
	}
	@RequiresPermissions("shop:shopCarts:add")
	@RequestMapping(value = "subtractGoods")
	public String subtractGoods(ShopCarts shopCarts, Model model, RedirectAttributes redirectAttributes) {
		ShopCarts durShopCarts = shopCartsService.get(shopCarts.getId());
		shopCartsService.subtractGoods(durShopCarts);
		return "redirect:"+Global.getAdminPath()+"/shop/shopOrder/form?memberCode="+durShopCarts.getMemberCode();
	}	@RequiresPermissions("shop:shopCarts:add")
	@RequestMapping(value = "addGoods")
	public String addGoods(ShopCarts shopCarts, Model model, RedirectAttributes redirectAttributes) {
		ShopCarts durShopCarts = shopCartsService.get(shopCarts.getId());
		shopCartsService.addGoods(durShopCarts);
		return "redirect:"+Global.getAdminPath()+"/shop/shopOrder/form?memberCode="+durShopCarts.getMemberCode();
	}
	@RequiresPermissions("shop:shopCarts:delete")
	@RequestMapping(value = "delete")
	public String delete(ShopCarts shopCarts, RedirectAttributes redirectAttributes) {
		shopCartsService.delete(shopCarts);
		return "redirect:"+Global.getAdminPath()+"/shop/shopOrder/form?memberCode="+shopCarts.getMemberCode();
	}

}