package com.cku.oa.groomer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.groomer.entity.GroomerExamQuestionBank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.groomer.service.GroomerExamQuestionBankService;

/**
 * 美容考试题库相关crudController
 * @author hjx
 * @version 2023-11-23
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerExamQuestionBank")
public class GroomerExamQuestionBankController extends BaseController {

	@Autowired
	private GroomerExamQuestionBankService groomerExamQuestionBankService;
	
	@ModelAttribute
	public GroomerExamQuestionBank get(@RequestParam(required=false) String id) {
		GroomerExamQuestionBank entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerExamQuestionBankService.get(id);
		}
		if (entity == null){
			entity = new GroomerExamQuestionBank();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:groomerExamQuestionBank:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerExamQuestionBank groomerExamQuestionBank, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerExamQuestionBank> page = groomerExamQuestionBankService.findPage(new Page<GroomerExamQuestionBank>(request, response), groomerExamQuestionBank); 
		model.addAttribute("page", page);
		return "oa/groomer/groomerExamQuestionBankList";
	}

	@RequiresPermissions("groomer:groomerExamQuestionBank:view")
	@RequestMapping(value = "form")
	public String form(GroomerExamQuestionBank groomerExamQuestionBank, Model model) {
		model.addAttribute("groomerExamQuestionBank", groomerExamQuestionBank);
		return "oa/groomer/groomerExamQuestionBankForm";
	}

	@RequiresPermissions("groomer:groomerExamQuestionBank:edit")
	@RequestMapping(value = "save")
	public String save(GroomerExamQuestionBank groomerExamQuestionBank, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerExamQuestionBank)){
			return form(groomerExamQuestionBank, model);
		}
		groomerExamQuestionBankService.save(groomerExamQuestionBank);
		addMessage(redirectAttributes, "保存美容考试题库成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerExamQuestionBank/?repage";
	}
	
	@RequiresPermissions("groomer:groomerExamQuestionBank:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerExamQuestionBank groomerExamQuestionBank, RedirectAttributes redirectAttributes) {
		groomerExamQuestionBankService.delete(groomerExamQuestionBank);
		addMessage(redirectAttributes, "删除美容考试题库成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerExamQuestionBank/?repage";
	}

}