package com.cku.oa.groomer.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.constant.Constants;
import com.cku.oa.groomer.dao.GroomerRegisterDao;
import com.cku.oa.groomer.entity.*;
import com.cku.oa.groomer.enums.DogCategorysEnum;
import com.cku.oa.groomer.vo.FciGroomerQualificationCertificateVO;
import com.cku.oa.groomer.vo.GroomerQualificationCertificateVO;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.util.Img2Base64Util;
import com.cku.oa.sys.zalog.SysContext;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.groomer.dao.FciGroomerQualificationCertificateDao;

import javax.servlet.http.HttpServletResponse;

/**
 * fci资格证书Service
 * @author hjx
 * @version 2024-01-17
 */
@Service
@Transactional(readOnly = true)
public class FciGroomerQualificationCertificateService extends CrudService<FciGroomerQualificationCertificateDao, FciGroomerQualificationCertificate> {

	@Autowired
	public ExpressQueueService expressQueueService;

	@Autowired
	private GroomerShowRefereeService groomerShowRefereeService;

	@Autowired
	private GroomerRegisterDao groomerRegisterDao;

	@Autowired
	public RemindService remindService;

	@Autowired
	private FileService fileService;

	@Autowired
	private GroomerShowService groomerShowService;
	public FciGroomerQualificationCertificate get(String id) {
		return super.get(id);
	}
	
	public List<FciGroomerQualificationCertificate> findList(FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		return super.findList(fciGroomerQualificationCertificate);
	}
	
	public Page<FciGroomerQualificationCertificate> findPage(Page<FciGroomerQualificationCertificate> page, FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		fciGroomerQualificationCertificate.setPage(page);
		return super.findPage(page, fciGroomerQualificationCertificate);
	}
	
	@Transactional(readOnly = false)
	public void save(FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		super.save(fciGroomerQualificationCertificate);
	}
	
	@Transactional(readOnly = false)
	public void delete(FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		super.delete(fciGroomerQualificationCertificate);
	}

	public List<FciGroomerQualificationCertificate> queryFciGroomerQualificationCertificateList(List<String> certificateIds) {

		return dao.queryFciGroomerQualificationCertificateList(certificateIds);
	}

	/**
	 * 打印Fci增发美容师资格证书
	 *
	 * @Author Hjx
	 * @2024年1月22日 16:35:56
	 */
	@Transactional(readOnly = false)
	public GroomerQualificationCertificate printAdditionalIssuanceFci(String id) {
		logger.info("FciGroomerQualificationCertificateService printFci param : {}", id);
		FciGroomerQualificationCertificate fgqc = super.get(id);
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "Fci美容师资格证书打印", fgqc.getMemberCode(), "fci_groomer_qualification_certificate",
				fgqc.getId(), fgqc.getRunningNumber(), (str) -> {
				});
		fgqc.setPrintState("1");
		dao.resetFciPrint(fgqc);
		GroomerRegister groomerRegister = dao.print(id);
		logger.info("FciGroomerQualificationCertificateService dao.print result : {}", JSONObjectUtils.toJsonString(groomerRegister));
		GroomerQualificationCertificate groomerQualificationCertificate = groomerRegister.getGroomerQualificationCertificate();
		Date takeCertificateDate = groomerQualificationCertificate.getTakeCertificateDate();
		String showDogBreed = groomerRegister.getShowDogBreed();
		String showDogBreedExtra = groomerRegister.getShowDogBreedExtra();
		Set<Integer> dogCategorys = new HashSet<>();
		if (StringUtils.isNotBlank(groomerRegister.getId())) {
			//打印fci证书中的犬的类别对应的数字
			if (StringUtils.isNotBlank(showDogBreed)) {
				String[] split = showDogBreed.split(",");
				for (String s : split) {
					for (String string : s.split(" ")) {
						if (!Objects.equals(string, "无")) {
							DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
							dogCategorys.add(byDogCategoryName.getCategory());
						}
					}
				}
			}
			if (StringUtils.isNotBlank(showDogBreedExtra)) {
				String[] split = showDogBreedExtra.split(",");
				for (String s : split) {
					for (String string : s.split(" ")) {
						DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
						dogCategorys.add(byDogCategoryName.getCategory());
					}
				}

			}
		} else {
			String dogCategory = groomerRegister.getGroomerQualificationCertificate().getFciGroomerQualificationCertificate().getDogCategory();
			if (StringUtils.isNotBlank(dogCategory)) {
				String[] split = dogCategory.split(";");
				for (String s : split) {
					for (String string : s.split(" ")) {
						DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
						dogCategorys.add(byDogCategoryName.getCategory());
					}
				}

			}
		}

		StringBuilder stringBuilder = new StringBuilder();
        Object[] array = dogCategorys.stream().distinct().toArray();
		for (int i = 0; i < array.length; i++) {
			if (i != array.length - 1) {
				stringBuilder.append(array[i]).append("、");
			} else {
				stringBuilder.append(array[i]);
			}
		}
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = new FciGroomerQualificationCertificate();
		fciGroomerQualificationCertificate.setDogCategorys(stringBuilder.toString());
		logger.info("----------------------groomerQualificationCertificate.getReferee() : {}---------------------------", JSONObjectUtils.toJsonString(groomerQualificationCertificate.getReviewer()));
		if (StringUtils.isNotBlank(groomerQualificationCertificate.getReviewer())) {
			String[] refereeSpilt = groomerQualificationCertificate.getReviewer().split(";");
			List<String> refereeSignaturePhotoBase64List = new ArrayList<>();
			for (int i = 0; i < refereeSpilt.length; i++) {
				//查询美容裁判信息
				GroomerShowReferee groomerShowReferee = groomerShowRefereeService.getLikeGroomerShowReferee(refereeSpilt[i]);
				logger.info("----------------------groomerShowReferee : {}---------------------------", JSONObjectUtils.toJsonString(groomerShowReferee));
				//判空
				if (Objects.nonNull(groomerShowReferee)) {
					//裁判名称
					if (i == refereeSpilt.length - 1) {
						groomerQualificationCertificate.setReferee((groomerQualificationCertificate.getReferee() == null ? "" : groomerQualificationCertificate.getReferee()) + groomerShowReferee.getRefereeNameEn());
					} else {
						groomerQualificationCertificate.setReferee((groomerQualificationCertificate.getReferee() == null ? "" : groomerQualificationCertificate.getReferee()) + groomerShowReferee.getRefereeNameEn() + ",");
					}
					//拿到裁判签名
					BaseFile file = fileService.get(groomerShowReferee.getRefereeSignaturePhoto());
					ByteArrayOutputStream outPut = null;
					if (Objects.nonNull(file)) {
						outPut = new ByteArrayOutputStream();
						fileService.fileDownload(file, outPut);
						refereeSignaturePhotoBase64List.add("data:" + file.getType() + ";base64," + Img2Base64Util.getImgStr(outPut.toByteArray()));
					}
				}
			}
			fciGroomerQualificationCertificate.setRefereeSignaturePhotoBase64List(
					refereeSignaturePhotoBase64List);
		}


		//将fci信息放入到资格证书中
		groomerQualificationCertificate.setFciGroomerQualificationCertificate(fciGroomerQualificationCertificate);
		String taskDate = "";
		if (takeCertificateDate != null) {
			LocalDate localDate = takeCertificateDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
			String monthName = localDate.getMonth().name();
			int year = localDate.getYear();
			int dayOfMonth = localDate.getDayOfMonth();
			taskDate = dayOfMonth + " " + monthName + " " + year;
		}
		Member member = groomerRegister.getMember();
		String nameEn = member.getNameEn();
		member.setName(member.getName() + " " + nameEn);
		groomerQualificationCertificate.setMember(member);
		groomerQualificationCertificate.setTaskDate(taskDate);
		groomerQualificationCertificate.setId(id);

		/*GroomerShowReferee groomerShowReferee = groomerShowRefereeService.getGroomerShowReferee(groomerRegister.getReferee());
		if (Objects.nonNull(groomerShowReferee)) {
			String sex = "";
			if (Objects.equals(groomerShowReferee.getRefereeSex(), "1")) {
				sex = "MR.";
			} else if (Objects.equals(groomerShowReferee.getRefereeSex(), "2")) {
				sex = "MRS.";
			}*/

		/*}*/


		// 推送消息
		expressQueueService.push(fgqc.getMemberCode(), fgqc.getRunningNumber(), "FCI美容资格证书", fgqc.getFciCertificateCode(),
				null); // GYH2 TODO

		return groomerQualificationCertificate;
	}

	@Transactional(rollbackFor = Exception.class)
	public void resetPrintFci(FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		fciGroomerQualificationCertificate.setPrintState(Constants.STRING_ZERO);
		dao.resetFciPrint(fciGroomerQualificationCertificate);
	}

	/**
	 * 批量提醒
	 * @param ids
	 * @throws ZAException
	 */
	@Transactional(readOnly = false)
	public void ficReminder(String ids) throws ZAException {
		String[] id = ids.split(",");
		for (int i = 0; i < id.length; i++) {
			FciGroomerQualificationCertificate fciGroomerQualificationCertificate = dao.get(id[i]);
			String paymentState = fciGroomerQualificationCertificate.getPaymentState();
			String memberCode = fciGroomerQualificationCertificate.getMemberCode();
			String registerId = fciGroomerQualificationCertificate.getRegisterId();
			GroomerRegister register = groomerRegisterDao.get(registerId);
			if (register != null) {
				Date date = new Date();
				Date gradeTime = register.getGradeTime();// 录入成绩的时间
				Calendar ca = Calendar.getInstance();
				ca.setTime(gradeTime);
				ca.add(Calendar.DATE, 180);// num为增加的天数，可以改变的
				Date date2 = ca.getTime();
				int day = getDay(date, date2);
				String showName = register.getGroomerShow().getShowName();
				// 未申领的才提醒
				if ("1".equals(paymentState)) {
					remindService.addMemberRemind("您参加" + showName.trim() + "的成绩将于" + day + "天后到期，请您及时申领FCI资格证书，逾期将不可以办理。",
							memberCode);
				}
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "数据异常,请联系管理员");
			}
		}
	}

	@Transactional
	public void updateFciCertificateState(String id){
		dao.updateFciCertificateState(id);
	}

	public FciGroomerQualificationCertificate getByCertificateId(String certificateId) {
		logger.info("FciGroomerQualificationCertificateService getByCertificateId certificateId : {}", certificateId);
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = dao.getByCertificateId(certificateId);
		logger.info("FciGroomerQualificationCertificateService getByCertificateId result : {}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificate));
		return fciGroomerQualificationCertificate;
	}

	public List<FciGroomerQualificationCertificate> eqCertificatepay(String memberCode, String levelEn){
		logger.info("FciGroomerQualificationCertificateService eqCertificatepay memberCode : {}, levelEn : {}", memberCode, levelEn);
		List<FciGroomerQualificationCertificate> fciGroomerQualificationCertificates = dao.eqCertificatepay(memberCode, levelEn);
		logger.info("FciGroomerQualificationCertificateService eqCertificatepay result : {}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificates));
		return fciGroomerQualificationCertificates;
	}

	/**
	 * 成绩录入通过生成证书
	 *
	 * @Author chaixueteng
	 * @2016年8月20日下午3:58:15
	 */
	@Transactional(readOnly = false)
	public void saveCertificate(FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		String memberCode = fciGroomerQualificationCertificate.getMemberCode();
		String levelEn = fciGroomerQualificationCertificate.getLevelEn();
		List<FciGroomerQualificationCertificate> list = dao.eqCertificate(memberCode, levelEn);
		if (list.size() <= 0) {
			dao.insert(fciGroomerQualificationCertificate);
		} else {// 如果同会员号同级别已有证书信息 则
			for (FciGroomerQualificationCertificate fciGroomerQualificationCertificate2 : list) {
				fciGroomerQualificationCertificate2.setRemarks("第二次考同级别证书,本证书作废!");
				dao.deleteFciCertificate(fciGroomerQualificationCertificate2);
			}
			dao.insert(fciGroomerQualificationCertificate);
		}
	}

	/**
	 * 查询会员的最新的级别
	 *
	 * @Author chaixueteng
	 * @2016年7月25日下午4:11:06
	 */
	public FciGroomerQualificationCertificate getLevel(String memberCode) {
		List<FciGroomerQualificationCertificate> list = dao.getLevel(memberCode);
		if (list.size() > 0) {
			FciGroomerQualificationCertificate gqc = list.get(0);
			if ("MASTER".equals(gqc.getLevelEn().trim())) {// 如果是教师资格证书
				return gqc;
			} else {// 不存在教师级证书 返回最大的级别
				return list.get(list.size() - 1);
			}
		}
		return null;
	}

	/**
	 * 打印Fci美容师资格证书 (美容大赛)
	 *
	 * @Author Hjx
	 * @2024年1月22日 16:35:56
	 */
	@Transactional(readOnly = false)
	public FciGroomerQualificationCertificate printFci(String id) {
		logger.info("FciGroomerQualificationCertificateService printFci param : {}", id);
		FciGroomerQualificationCertificate fgqc = super.get(id);
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "Fci美容师资格证书打印", fgqc.getMemberCode(), "fci_groomer_qualification_certificate",
				fgqc.getId(), fgqc.getRunningNumber(), (str) -> {
				});
		fgqc.setPrintState("1");
		dao.resetFciPrint(fgqc);
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = dao.printFciShowQGC(id);
		//美容活动报名表
		GroomerRegister groomerRegister = fciGroomerQualificationCertificate.getGroomerRegister();
		//美容活动表
		GroomerShow groomerShow = fciGroomerQualificationCertificate.getGroomerShow();
		logger.info("FciGroomerQualificationCertificateService dao.print result : {}", JSONObjectUtils.toJsonString(fciGroomerQualificationCertificate));
		Date takeCertificateDate = fciGroomerQualificationCertificate.getTakeCertificateDate();
		String showDogBreed = groomerRegister.getShowDogBreed();
		String showDogBreedExtra = groomerRegister.getShowDogBreedExtra();
		Set<Integer> dogCategorys = new HashSet<>();
		if (StringUtils.isNotBlank(groomerRegister.getId())) {
			//打印fci证书中的犬的类别对应的数字
			if (StringUtils.isNotBlank(showDogBreed)) {
				String[] split = showDogBreed.split(",");
				for (String s : split) {
					for (String string : s.split(" ")) {
						if (!Objects.equals(string, "无")) {
							DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
							dogCategorys.add(byDogCategoryName.getCategory());
						}
					}
				}
			}
			if (StringUtils.isNotBlank(showDogBreedExtra)) {
				String[] split = showDogBreedExtra.split(",");
				for (String s : split) {
					for (String string : s.split(" ")) {
						DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
						dogCategorys.add(byDogCategoryName.getCategory());
					}
				}

			}
		} else {
			String dogCategory = groomerRegister.getGroomerQualificationCertificate().getFciGroomerQualificationCertificate().getDogCategory();
			if (StringUtils.isNotBlank(dogCategory)) {
				String[] split = dogCategory.split(";");
				for (String s : split) {
					for (String string : s.split(" ")) {
						DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
						dogCategorys.add(byDogCategoryName.getCategory());
					}
				}

			}
		}

		StringBuilder stringBuilder = new StringBuilder();
		Object[] array = dogCategorys.stream().distinct().toArray();
		for (int i = 0; i < array.length; i++) {
			if (i != array.length - 1) {
				stringBuilder.append(array[i]).append("、");
			} else {
				stringBuilder.append(array[i]);
			}
		}
		fciGroomerQualificationCertificate.setDogCategorys(stringBuilder.toString());
		if (StringUtils.isNotBlank(groomerShow.getReferee())) {
			String[] refereeSpilt = fciGroomerQualificationCertificate.getReferee().split(";");
			List<String> refereeSignaturePhotoBase64List = new ArrayList<>();
			String referee = fciGroomerQualificationCertificate.getReferee().replaceAll(";", ",");
			fciGroomerQualificationCertificate.setReferee(referee);
			for (int i = 0; i < refereeSpilt.length; i++) {
				//查询美容裁判信息
				GroomerShowReferee groomerShowReferee = groomerShowRefereeService.getLikeGroomerShowReferee(refereeSpilt[i]);
				logger.info("----------------------groomerShowReferee : {}---------------------------", JSONObjectUtils.toJsonString(groomerShowReferee));
				//判空
				if (Objects.nonNull(groomerShowReferee)) {
					/*//裁判名称
					if (refereeSpilt.length == 1) {
						fciGroomerQualificationCertificate.setReferee(groomerShowReferee.getRefereeNameEn());
					} else {
						if (i == refereeSpilt.length - 1) {
							fciGroomerQualificationCertificate.setReferee(fciGroomerQualificationCertificate.getReferee() + groomerShowReferee.getRefereeNameEn());
						} else {
							if ( i == 0) {
								fciGroomerQualificationCertificate.setReferee(groomerShowReferee.getRefereeNameEn() + ",");
							} else {
								fciGroomerQualificationCertificate.setReferee(fciGroomerQualificationCertificate.getReferee() + groomerShowReferee.getRefereeNameEn() + ",");
							}
						}
					}*/
					//拿到裁判签名
					BaseFile file = fileService.get(groomerShowReferee.getRefereeSignaturePhoto());
					ByteArrayOutputStream outPut = null;
					if (Objects.nonNull(file)) {
						outPut = new ByteArrayOutputStream();
						fileService.fileDownload(file, outPut);
						refereeSignaturePhotoBase64List.add("data:" + file.getType() + ";base64," + Img2Base64Util.getImgStr(outPut.toByteArray()));
					}
				}
			}
			fciGroomerQualificationCertificate.setRefereeSignaturePhotoBase64List(
					refereeSignaturePhotoBase64List);
		}

		String taskDate = "";
		if (takeCertificateDate != null) {
			LocalDate localDate = takeCertificateDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
			String monthName = localDate.getMonth().name();
			int year = localDate.getYear();
			int dayOfMonth = localDate.getDayOfMonth();
			taskDate = dayOfMonth + " " + monthName + " " + year;
		}
		Member member = fciGroomerQualificationCertificate.getMember();
		String nameEn = member.getNameEn();
		member.setName(member.getName() + " " + nameEn);
		fciGroomerQualificationCertificate.setMember(member);
		fciGroomerQualificationCertificate.setTaskDate(taskDate);

		/*GroomerShowReferee groomerShowReferee = groomerShowRefereeService.getGroomerShowReferee(groomerRegister.getReferee());
		if (Objects.nonNull(groomerShowReferee)) {
			String sex = "";
			if (Objects.equals(groomerShowReferee.getRefereeSex(), "1")) {
				sex = "MR.";
			} else if (Objects.equals(groomerShowReferee.getRefereeSex(), "2")) {
				sex = "MRS.";
			}*/

		/*}*/


		// 推送消息
		expressQueueService.push(fgqc.getMemberCode(), fgqc.getRunningNumber(), "FCI美容资格证书", fgqc.getFciCertificateCode(),
				null); // GYH2 TODO

		return fciGroomerQualificationCertificate;
	}

	/**
	 * Fci资格证书导出(搜索维度)
	 * @throws IOException
	 * @Author hjx
	 */
	public void export(FciGroomerQualificationCertificate fciGroomerQualificationCertificate, HttpServletResponse response)
			throws IOException {
		/*List<GroomerQualificationCertificate> gqcList = dao.getCertificateList(groomerQualificationCertificate);*/
		List<FciGroomerQualificationCertificateVO> fciGroomerQualificationCertificateVOS = dao.exportFciGroomerQualificationCertificates(fciGroomerQualificationCertificate);
		for (FciGroomerQualificationCertificateVO fciGroomerQualificationCertificateVO : fciGroomerQualificationCertificateVOS) {
			fciGroomerQualificationCertificateVO.setGender("male".equals(fciGroomerQualificationCertificateVO.getGender()) ? "男" : "女");
			fciGroomerQualificationCertificateVO.setLevelCn(DictUtils.getDictLabel(fciGroomerQualificationCertificateVO.getLevelEn(), "groomer_test_level", null));
		}

		String fileName = "Fci美容资格证书.xlsx";

		new ExportExcel("", GroomerQualificationCertificateVO.class, 2).setDataList(fciGroomerQualificationCertificateVOS).write(response, fileName)
				.dispose();
	}

	/**
	 * 批量提醒
	 *
	 * @Author chaixueteng
	 * @2016年8月3日下午4:27:51
	 */
	@Transactional(readOnly = false)
	public void batchrReminder(String ids) throws ZAException {
		String[] id = ids.split(",");
		for (int i = 0; i < id.length; i++) {
			FciGroomerQualificationCertificate fciGroomerQualificationCertificate = dao.get(id[i]);
			String paymentState = fciGroomerQualificationCertificate.getPaymentState();
			String memberCode = fciGroomerQualificationCertificate.getMemberCode();
			String registerId = fciGroomerQualificationCertificate.getRegisterId();
			GroomerRegister register = groomerRegisterDao.get(registerId);
			if (register != null) {
				Date date = new Date();
				Date gradeTime = register.getGradeTime();// 录入成绩的时间
				Calendar ca = Calendar.getInstance();
				ca.setTime(gradeTime);
				ca.add(Calendar.DATE, 180);// num为增加的天数，可以改变的
				Date date2 = ca.getTime();
				int day = getDay(date, date2);
				String showName = register.getGroomerShow().getShowName();
				// 未申领的才提醒
				if ("1".equals(paymentState)) {
					remindService.addMemberRemind("您参加" + showName.trim() + "的成绩将于" + day + "天后到期，请您及时申领Fci资格证书，逾期将不可以办理。",
							memberCode);
				}
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "数据异常,请联系管理员");
			}
		}

	}



	/**
	 * 指定日期加上天数后的日期
	 */
	public int getDay(Date beginDate, Date endDate) {
		// 将转换的两个时间对象转换成Calendard对象
		Calendar can1 = Calendar.getInstance();
		can1.setTime(beginDate);
		Calendar can2 = Calendar.getInstance();
		can2.setTime(endDate);
		// 拿出两个年份
		int year1 = can1.get(Calendar.YEAR);
		int year2 = can2.get(Calendar.YEAR);
		// 天数
		int days = 0;
		Calendar can = null;
		// 如果can1 < can2
		// 减去小的时间在这一年已经过了的天数
		// 加上大的时间已过的天数
		if (can1.before(can2)) {
			days -= can1.get(Calendar.DAY_OF_YEAR);
			days += can2.get(Calendar.DAY_OF_YEAR);
			can = can1;
		} else {
			days -= can2.get(Calendar.DAY_OF_YEAR);
			days += can1.get(Calendar.DAY_OF_YEAR);
			can = can2;
		}
		for (int i = 0; i < Math.abs(year2 - year1); i++) {
			// 获取小的时间当前年的总天数
			days += can.getActualMaximum(Calendar.DAY_OF_YEAR);
			// 再计算下一年。
			can.add(Calendar.YEAR, 1);
		}
		System.out.println("天数差：" + days);
		return days;
	}

	public FciGroomerQualificationCertificateVo mobileFciCertificateDetailInfo(FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		Date takeCertificateDate = fciGroomerQualificationCertificate.getTakeCertificateDate();
		GroomerRegister groomerRegister = groomerRegisterDao.get(fciGroomerQualificationCertificate.getRegisterId());
		logger.info("----------groomerRegister-------:{}", JSONObjectUtils.toJsonString(groomerRegister));
		GroomerShow groomerShow = groomerShowService.getShowCode(groomerRegister.getShowCode());
		logger.info("----------groomerShow-------:{}", JSONObjectUtils.toJsonString(groomerShow));
		FciGroomerQualificationCertificateVo fciGroomerQualificationCertificateVo = new FciGroomerQualificationCertificateVo();
		String showDogBreed = groomerRegister.getShowDogBreed();
		String showDogBreedExtra = groomerRegister.getShowDogBreedExtra();
		Set<Integer> dogCategorys = new HashSet<>();
		if (StringUtils.isNotBlank(groomerRegister.getId())) {
			//打印fci证书中的犬的类别对应的数字
			if (StringUtils.isNotBlank(showDogBreed)) {
				String[] split = showDogBreed.split(",");
				for (String s : split) {
					for (String string : s.split(" ")) {
						if (!Objects.equals(string, "无")) {
							DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
							dogCategorys.add(byDogCategoryName.getCategory());
						}
					}
				}
			}
			if (StringUtils.isNotBlank(showDogBreedExtra)) {
				String[] split = showDogBreedExtra.split(",");
				for (String s : split) {
					for (String string : s.split(" ")) {
						DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
						dogCategorys.add(byDogCategoryName.getCategory());
					}
				}

			}
		} else {
			String dogCategory = groomerRegister.getGroomerQualificationCertificate().getFciGroomerQualificationCertificate().getDogCategory();
			if (StringUtils.isNotBlank(dogCategory)) {
				String[] split = dogCategory.split(";");
				for (String s : split) {
					for (String string : s.split(" ")) {
						DogCategorysEnum byDogCategoryName = DogCategorysEnum.getByDogCategoryName(string);
						dogCategorys.add(byDogCategoryName.getCategory());
					}
				}

			}
		}

		StringBuilder stringBuilder = new StringBuilder();
		Object[] array = dogCategorys.stream().distinct().toArray();
		for (int i = 0; i < array.length; i++) {
			if (i != array.length - 1) {
				stringBuilder.append(array[i]).append("、");
			} else {
				stringBuilder.append(array[i]);
			}
		}
		fciGroomerQualificationCertificateVo.setDogCategorys(stringBuilder.toString());
		if (StringUtils.isNotBlank(fciGroomerQualificationCertificate.getReferee())) {
			String[] refereeSpilt = fciGroomerQualificationCertificate.getReferee().split(";");
			List<String> refereeSignaturePhotoBase64List = new ArrayList<>();
			String referee = fciGroomerQualificationCertificate.getReferee().replaceAll(";", ",");
			fciGroomerQualificationCertificate.setReferee(referee);
			fciGroomerQualificationCertificateVo.setReferee(fciGroomerQualificationCertificate.getReferee());
			for (int i = 0; i < refereeSpilt.length; i++) {
				//查询美容裁判信息
				GroomerShowReferee groomerShowReferee = groomerShowRefereeService.getLikeGroomerShowReferee(refereeSpilt[i]);
				logger.info("----------------------groomerShowReferee : {}---------------------------", JSONObjectUtils.toJsonString(groomerShowReferee));
				//判空
				if (Objects.nonNull(groomerShowReferee)) {
					/*//裁判名称
					if (refereeSpilt.length == 1) {
						fciGroomerQualificationCertificateVo.setReferee(groomerShowReferee.getRefereeNameEn());
					} else {
						if (i == refereeSpilt.length - 1) {
							fciGroomerQualificationCertificateVo.setReferee(fciGroomerQualificationCertificateVo.getReferee() + groomerShowReferee.getRefereeNameEn());
						} else {
							if ( i == 0) {
								fciGroomerQualificationCertificateVo.setReferee(groomerShowReferee.getRefereeNameEn() + ",");
							} else {
								fciGroomerQualificationCertificateVo.setReferee(fciGroomerQualificationCertificateVo.getReferee() + groomerShowReferee.getRefereeNameEn() + ",");
							}
						}
					}*/

					//拿到裁判签名
					BaseFile file = fileService.get(groomerShowReferee.getRefereeSignaturePhoto());
					ByteArrayOutputStream outPut = null;
					if (Objects.nonNull(file)) {
						outPut = new ByteArrayOutputStream();
						fileService.fileDownload(file, outPut);
						refereeSignaturePhotoBase64List.add("data:" + file.getType() + ";base64," + Img2Base64Util.getImgStr(outPut.toByteArray()));
					}
				}
			}
			fciGroomerQualificationCertificateVo.setRefereeSignaturePhotoBase64List(
					refereeSignaturePhotoBase64List);
		}

		String taskDate = "";
		if (takeCertificateDate != null) {
			LocalDate localDate = takeCertificateDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
			String monthName = localDate.getMonth().name();
			int year = localDate.getYear();
			int dayOfMonth = localDate.getDayOfMonth();
			taskDate = dayOfMonth + " " + monthName + " " + year;
		}
		Member member = fciGroomerQualificationCertificate.getMember();
		String nameEn = member.getNameEn();
		fciGroomerQualificationCertificateVo.setName(member.getName() + " " + nameEn);
		fciGroomerQualificationCertificateVo.setTakeCertificateDate(taskDate);
		fciGroomerQualificationCertificateVo.setId(fciGroomerQualificationCertificate.getId());


		return fciGroomerQualificationCertificateVo;
	}
}