package com.cku.oa.gcWeb.service;

import com.cku.oa.gcWeb.dao.GCWebInfoDao;
import com.cku.oa.gcWeb.entity.GCWebInfo;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 美容官网信息Service
 * @author yuanshuai
 * @version 2023-01-30
 */
@Service
@Transactional(readOnly = true)
public class GCWebInfoService extends CrudService<GCWebInfoDao, GCWebInfo> {

	public GCWebInfo get(String id) {
		return super.get(id);
	}
	
	public List<GCWebInfo> findList(GCWebInfo gcWebInfo) {
		return super.findList(gcWebInfo);
	}
	
	public Page<GCWebInfo> findPage(Page<GCWebInfo> page, GCWebInfo gcWebInfo) {
		return super.findPage(page, gcWebInfo);
	}
	
	@Transactional(readOnly = false)
	public void save(GCWebInfo gcWebInfo) {
		super.save(gcWebInfo);
	}
	
	@Transactional(readOnly = false)
	public void delete(GCWebInfo gcWebInfo) {
		super.delete(gcWebInfo);
	}
	
}