/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBirthCertificateApply;
import com.cku.oa.dog.entity.DogBirthCertificateTransfer;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBirthCertificateTransferService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.vo.DogBirthCertificateVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.vo.PaymentOrderDetailQueryVO;
import com.cku.oa.sys.util.RequestUtil;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Office;
import com.thinkgem.jeesite.modules.sys.service.OfficeService;

/**
 * 出生证明Controller
 *
 * @author lgl
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "${adminPath}/birthcertificate/dogBirthCertificate")
public class DogBirthCertificateController extends BaseController {

	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private OfficeService officeService;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogChipDao dogChipDao;
	@Autowired
	private DogBirthCertificateTransferService dogBirthCertificateTransferService;

	private final static String REPAGE = "redirect:" + Global.getAdminPath()
			+ "/birthcertificate/dogBirthCertificate/?repage";

	private final static String AUTHORITY_PRDFIX = "birthcertificate:dogBirthCertificate:";

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogBirthCertificateApply",
				new DogBirthCertificateApply(runningNumber, chargingItemId, memberCode));
		return "oa/dog/birthcertificate/dogBirthCertificateOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getByFmdogBreedCertifiedCode")
	@ResponseBody
	public Object getByFmdogBreedCertifiedCode(@RequestParam(required = true) String fmdogBreedCertifiedCode) {
		HashMap<String, String> map = dogBirthCertificateService.getByFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	public Object add(DogBirthCertificateApply dogBirthCertificateApply) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogBirthCertificateService.addOaSide(dogBirthCertificateApply);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogBirthCertificate dogBirthCertificate, Model model) {
		List<DogBirthCertificate> list = dogBirthCertificateService.findList(dogBirthCertificate);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService.getRefundStateByBusinessIdAOrderCode(list.stream()
				.map(a -> new PaymentOrderDetailQueryVO(a.getFmdogBreedCertifiedCode(), a.getRunningNumber()))
				.collect(Collectors.toList()));
		List<DogBirthCertificateVO> list2 = list.stream().map(a -> {
			DogBirthCertificateVO b = new DogBirthCertificateVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getFmdogBreedCertifiedCode() + a.getRunningNumber()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);
		return "oa/dog/birthcertificate/dogBirthCertificateOrderList";
	}

	@ModelAttribute
	public DogBirthCertificate get(@RequestParam(required = false) String id) {
		DogBirthCertificate entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogBirthCertificateService.get(id);
		}
		if (entity == null) {
			entity = new DogBirthCertificate();
		}
		return entity;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "transferList" })
	public String transferList(DogBirthCertificateTransfer dogBirthCertificateTransfer, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<DogBirthCertificateTransfer> page = dogBirthCertificateTransferService
				.findPage(new Page<DogBirthCertificateTransfer>(request, response), dogBirthCertificateTransfer);
		model.addAttribute("page", page);
		return "oa/dog/birthcertificate/transferList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = { "transferEditForm" })
	public String transferEditForm(DogBirthCertificateTransfer dogBirthCertificateTransfer, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		DogBirthCertificateTransfer transfer = dogBirthCertificateTransferService
				.get(dogBirthCertificateTransfer.getId());
		DogType dogType = dogTypeService.getByDogBreedCode(transfer.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		transfer.setDogBreed(dogBreedCnName);
		model.addAttribute("obj", transfer);
		return "oa/dog/birthcertificate/transferEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "transferEdit")
	public String transferEdit(DogBirthCertificateTransfer dogBirthCertificateTransfer, Model model,
			RedirectAttributes redirectAttributes) {
		DogBirthCertificateTransfer vo = new DogBirthCertificateTransfer();
		vo.setBusinessStatus(dogBirthCertificateTransfer.getBusinessStatus());
		vo.setRemarks(dogBirthCertificateTransfer.getRemark());
		vo.setId(dogBirthCertificateTransfer.getId());
		dogBirthCertificateTransferService.updateByParams(vo);
		addMessage(redirectAttributes, "修改登记卡变更记录成功");
		return "redirect:" + Global.getAdminPath() + "/birthcertificate/dogBirthCertificate/transferList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = { "transferForm" })
	public String transferForm(DogBirthCertificateTransfer dogBirthCertificateTransfer, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		DogBirthCertificateTransfer transfer = dogBirthCertificateTransferService
				.get(dogBirthCertificateTransfer.getId());
		DogType dogType = dogTypeService.getByDogBreedCode(transfer.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		transfer.setDogBreed(dogBreedCnName);
		model.addAttribute("obj", transfer);
		return "oa/dog/birthcertificate/transferForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogBirthCertificate dogBirthCertificate, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		// if(!RequestUtil.hasParameter(request)){
		// //没有参数的查询，默认只查询最近的三个月
		// Calendar calendar = Calendar.getInstance();//日历对象
		// Date date = new Date();
		// date.setHours(0);
		// date.setMinutes(0);
		// date.setSeconds(0);
		// calendar.setTime(date);//设置当前日期
		// calendar.add(Calendar.MONTH, -3);//年份+1
		// dogBirthCertificate.setBeginCreateDate(calendar.getTime());
		// }

		Page<DogBirthCertificate> page = dogBirthCertificateService
				.findPage(new Page<DogBirthCertificate>(request, response), dogBirthCertificate);
		for (DogBirthCertificate po : page.getList()) {
			po.setBusinessState(dogBirthCertificateService.getBusinessState(po));
			po.setUpperStatus(dogBirthCertificateService.getUpperStates(po));
			DogChip dogChip = dogChipDao.getByBirthCode(po.getBirthCerRegCode());
			if (dogChip != null) {
				po.setIsAll(dogChip.getIsAll());
			} else {
				po.setIsAll("0");
			}
			if (po.getCreateDate().getTime() >= DogBirthCertificateService.ACTICATION_OFF_MILLS) {
				po.setClassPrintFlag(false);
			} else {
				po.setClassPrintFlag(true);
			}
		}

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService.getRefundStateByBusinessIdAOrderCode(page.getList().stream()
				.map(a -> new PaymentOrderDetailQueryVO(a.getFmdogBreedCertifiedCode(), a.getRunningNumber()))
				.collect(Collectors.toList()));
		List<DogBirthCertificate> list = page.getList().stream().map(a -> {
			DogBirthCertificateVO b = new DogBirthCertificateVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getFmdogBreedCertifiedCode() + a.getRunningNumber()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);

		List<Office> agencyList = officeService.findAgency();
		Office other = new Office();
		other.setName("北京办事处");
		other.setId("other");
		agencyList.add(other);
		model.addAttribute("agencyList", agencyList);
		// 如果犬种是藏獒跳到藏獒页面（只比原来页面多固定了个犬种为230的隐藏input）
		if ("230".equals(dogBirthCertificate.getDogBreed())) {
			return "oa/dog/birthcertificate/dogBirthCertificateListZangao";
		}
		// 预设的参数不带回到页面
		if (!RequestUtil.hasParameter(request)) {
			dogBirthCertificate.setBeginCreateDate(null);
		}

		return "oa/dog/birthcertificate/dogBirthCertificateList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogBirthCertificate dogBirthCertificate, Model model) {
		DogActivation dogActivation = dogActivationService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (dogActivation != null) {
			String lifePic = dogActivation.getLifePic();
			if (StringUtils.isNotBlank(lifePic)) {
				String[] split = lifePic.split(",");
				model.addAttribute("pictures", split);
			}
			model.addAttribute("dogActivation", dogActivation);
		}
		DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		dogBirthCertificate.setDogBreedCnName(dogBreedCnName);
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBirthCertificate", dogBirthCertificate);
		return "oa/dog/birthcertificate/dogBirthCertificateForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogBirthCertificate dogBirthCertificate, Model model,
			RedirectAttributes redirectAttributes) {
		boolean allNest = dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		// if (allNest) {
		// addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
		// return repage(dogBirthCertificate);
		// }
		DogActivation dogActivation = dogActivationService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (dogActivation != null) {
			String lifePic = dogActivation.getLifePic();
			if (StringUtils.isNotBlank(lifePic)) {
				String[] split = lifePic.split(",");
				model.addAttribute("pictures", split);
			}
			model.addAttribute("dogActivation", dogActivation);
		}
		DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		dogBirthCertificate.setDogBreedCnName(dogBreedCnName);
		model.addAttribute("dogColorMarkList",
				dogColorMarkService.getByDogBreedCode(dogBirthCertificate.getDogBreed()));
		model.addAttribute("dogBirthCertificate", dogBirthCertificate);
		model.addAttribute("isCanInputIdentificationFlag",
				dogBirthCertificateService.isCanInputIdentificationFlag(dogBirthCertificate) == true ? "1" : "0");

		// 判断是否到11月11号
		Date createDate = dogBirthCertificate.getCreateDate();
		Date dateFlag = DateUtils.strToDateLong("2018-11-11 00:00:00");
		model.addAttribute("dateFlag", createDate.getTime() - dateFlag.getTime() > 0 ? true : false);

		return "oa/dog/birthcertificate/dogBirthCertificateEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(DogBirthCertificate dogBirthCertificate, Model model,
			RedirectAttributes redirectAttributes) {
		boolean allNest = dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		if (allNest) {
			addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
			return repage(dogBirthCertificate);
		}
		model.addAttribute("dogColorMarkList", dogColorMarkService.findAllList());
		model.addAttribute("dogBirthCertificate", dogBirthCertificate);
		return "oa/dog/birthcertificate/dogBirthCertificateAuditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "edit")
	public String edit(DogBirthCertificate dogBirthCertificate, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogBirthCertificate)) {
			return editForm(dogBirthCertificate, model, redirectAttributes);
		}
		dogBirthCertificateService.update(dogBirthCertificate);
		addMessage(redirectAttributes, "修改出生证明成功");
		return REPAGE + "&fmdogBreedCertifiedCode=" + dogBirthCertificate.getFmdogBreedCertifiedCode();
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogBirthCertificate dogBirthCertificate, RedirectAttributes redirectAttributes) {
		boolean allNest = dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		if (allNest) {
			addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
			return repage(dogBirthCertificate);
		}
		if ("2".equals(dogBirthCertificate.getPaymentState())) {
			addMessage(redirectAttributes, "该记录已缴费，不允许删除");
			return repage(dogBirthCertificate);
		}
		dogBirthCertificateService.delete(dogBirthCertificate);
		addMessage(redirectAttributes, "删除出生证明成功");
		return repage(dogBirthCertificate);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "deleteALL")
	@RequestMapping(value = "deleteAll")
	public String deleteAll(DogBirthCertificate dogBirthCertificate, RedirectAttributes redirectAttributes) {
		boolean allNest = dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		if (allNest) {
			addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
			return repage(dogBirthCertificate);
		}
		dogBirthCertificateService.deltelAll(dogBirthCertificate);
		addMessage(redirectAttributes, "删除出生证明成功");
		return repage(dogBirthCertificate);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "print")
	@RequestMapping(value = "print")
	public String print(DogBirthCertificate dogBirthCertificate, Model model, RedirectAttributes redirectAttributes) {
		// boolean allNest =
		// dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		// if (allNest) {
		// addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
		// return repage(dogBirthCertificate);
		// }
		try {
			return dogBirthCertificateService.print(dogBirthCertificate.getId(), model);
		} catch (ZAException e) {
			logger.warn("打印出错", e);
			addMessage(redirectAttributes, "打印出错:" + e.getMessage());
			return repage(dogBirthCertificate);
		}
	}

	/**
	 * 置顶取消置顶功能
	 *
	 * @param dogBirthCertificate
	 * @param model
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "firstStatus")
	public String firstStatus(DogBirthCertificate dogBirthCertificate, Model model,
			RedirectAttributes redirectAttributes) {
		DogBirthCertificate dog = dogBirthCertificateService.get(dogBirthCertificate.getId());
		String msg = null;
		if (StringUtils.isEmpty(dog.getFirstStatus()) || "1".equals(dog.getFirstStatus())) {
			dog.setFirstStatus("2");
			msg = "置顶成功";
		} else {
			if ("2".equals(dog.getFirstStatus())) {
				dog.setFirstStatus("1");
				msg = "取消置顶成功";
			}
		}
		dogBirthCertificateService.save(dog);
		addMessage(redirectAttributes, msg);
		return repage(dogBirthCertificate);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "print")
	@RequestMapping(value = "classPrint")
	public String classPrint(DogBirthCertificate dogBirthCertificate, Model model,
			RedirectAttributes redirectAttributes) {
		boolean allNest = dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		if (allNest) {
			addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
			return repage(dogBirthCertificate);
		}
		try {
			return dogBirthCertificateService.classPrint(dogBirthCertificate.getId(), model);
		} catch (ZAException e) {
			logger.warn("等级贴纸打印出错", e);
			addMessage(redirectAttributes, "等级贴纸打印出错:" + e.getMessage());
			return repage(dogBirthCertificate);
		}
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(DogBirthCertificate dogBirthCertificate, RedirectAttributes redirectAttributes) {
		// boolean allNest =
		// dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		// if (allNest) {
		// addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
		// return repage(dogBirthCertificate);
		// }
		dogBirthCertificateService.resetPrint(dogBirthCertificate);
		addMessage(redirectAttributes, "打印重置成功");
		if ("230".equals(dogBirthCertificate.getDogBreed())) {
			return REPAGE + "&dogBreed=230";
		}
		return repage(dogBirthCertificate);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resetPrint")
	@RequestMapping(value = "resetClassPrint")
	public String resetClassPrint(DogBirthCertificate dogBirthCertificate, RedirectAttributes redirectAttributes) {
		boolean allNest = dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		if (allNest) {
			addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
			return repage(dogBirthCertificate);
		}
		dogBirthCertificateService.resetClassPrint(dogBirthCertificate);
		addMessage(redirectAttributes, "等级贴纸打印重置成功");
		if ("230".equals(dogBirthCertificate.getDogBreed())) {
			return REPAGE + "&dogBreed=230";
		}
		return repage(dogBirthCertificate);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "audit")
	public String audit(DogBirthCertificate dogBirthCertificate, RedirectAttributes redirectAttributes) {
		addMessage(redirectAttributes, "审核成功");
		try {
			dogBirthCertificateService.audit(dogBirthCertificate);
		} catch (Exception e) {
			logger.warn("审核失败:", e.getMessage());
			addMessage(redirectAttributes, "审核失败:", e.getMessage());
		}
		return repage(dogBirthCertificate);
	}

	@RequestMapping(value = "getDogNames")
	@ResponseBody
	public Object getDogNames(String maleNum, String femaleNum) {
		return dogBirthCertificateService.getDogNames(maleNum, femaleNum);
	}

	/**
	 *
	 * @description: 根据犬种判断是否跳藏獒的列表页
	 * @author: laiguanglong
	 * @date: 2016年9月3日 下午3:48:33
	 */
	private String repage(DogBirthCertificate dogBirthCertificate) {
		if ("230".equals(dogBirthCertificate.getDogBreed())) {
			return REPAGE + "&dogBreed=230";
		}
		return REPAGE;
	}

	/**
	 *
	 * @Description：出生纸编号有效性查询
	 * @author: zhuoHeng
	 * @version: 2016年10月14日 下午4:51:48
	 */
	@RequestMapping(value = "getMessageByBirthCerRegCode")
	@ResponseBody
	public String getMessageByBirthCerRegCode(String birthCerRegCode) {
		String flag = dogBirthCertificateService.getMessageByBirthCerRegCode(birthCerRegCode);
		return flag;
	}

	/**
	 * 三码合一新增功能 根据芯片号生成宠爱护照号 宠爱登记卡好
	 *
	 * @param identificationFlag
	 * @return
	 */
	@RequestMapping(value = "createCabCode")
	@ResponseBody
	public Object createCabCode(String id, String identificationFlag) {
		Map<String, String> result = new HashMap<String, String>();
		try {
			result = dogBirthCertificateService.createCabCode(id, identificationFlag);
			result.put("rc", "0");
		} catch (Exception e) {
			result.put("msg", e.getMessage());
			result.put("rc", "1");
		}
		return result;

	}

	/**
	 *
	 * @Description：根据出生纸编号查询出生纸信息
	 * @author: zhuoHeng
	 * @version: 2016年10月24日 下午12:05:54
	 */
	@RequestMapping(value = "getBirthCerRegByCode")
	@ResponseBody
	public Object getBirthCerRegByCode(HttpServletRequest requset) {
		String birthCerRegCode = requset.getParameter("birthCerRegCode");
		Map<String, String> map = dogBirthCertificateService.getBirthCerRegByCode(birthCerRegCode);
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "reGetForm")
	public String reGetForm(DogBirthCertificate dogBirthCertificate, Model model) {
		return dogBirthCertificateService.reGetForm(dogBirthCertificate, model);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "reGet")
	public String reGet(DogBirthCertificate dogBirthCertificate, HttpServletRequest request,
			RedirectAttributes redirectAttributes) {
		boolean allNest = dogBirthCertificateService.isAllNest(dogBirthCertificate.getBirthCerRegCode());
		if (allNest) {
			addMessage(redirectAttributes, "整窝申请血统证书的出生纸不允许该项操作");
			return repage(dogBirthCertificate);
		}
		if (!"3".equals(dogBirthCertificate.getReviewState())) {
			addMessage(redirectAttributes, "该记录不是已注销，不允许重领");
			return repage(dogBirthCertificate);
		}
		dogBirthCertificateService.reGet(dogBirthCertificate, request);
		addMessage(redirectAttributes, "重领出生证明成功");
		return repage(dogBirthCertificate);
	}

}