package com.cku.oa.appreciation.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.appreciation.entity.AppreciationCourses;
import com.cku.oa.appreciation.service.AppreciationCoursesCoursewareRefService;
import com.cku.oa.appreciation.service.AppreciationCoursesService;
import com.cku.oa.appreciation.service.AppreciationCoursewareService;
import com.cku.oa.appreciation.vo.CoursesCoursewareRefRequest;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 课程管理Controller
 *
 * @author xx
 * @version 2022-02-17
 */
@Controller
@RequestMapping(value = "${adminPath}/appreciation/appreciationCourses")
public class AppreciationCoursesController extends BaseController {

	@Autowired
	private AppreciationCoursesService appreciationCoursesService;
	@Autowired
	private AppreciationCoursesCoursewareRefService appreciationCoursesCoursewareRefService;

	@ModelAttribute
	public AppreciationCourses get(@RequestParam(required = false) String id) {
		AppreciationCourses entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = appreciationCoursesService.get(id);
		}
		if (entity == null) {
			entity = new AppreciationCourses();
		}
		return entity;
	}

	@RequiresPermissions("appreciation:appreciationCourses:view")
	@RequestMapping(value = {"list", ""})
	public String list(AppreciationCourses appreciationCourses, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<AppreciationCourses> page = appreciationCoursesService.findPage(new Page<>(request, response), appreciationCourses);
		model.addAttribute("page", page);
		return "oa/appreciation/appreciationCourses/appreciationCoursesList";
	}

	@RequiresPermissions("appreciation:appreciationCourses:edit")
	@RequestMapping(value = "editForm")
	public String editForm(AppreciationCourses appreciationCourses, Model model) {
		model.addAttribute("appreciationCourses", appreciationCourses);
		return "oa/appreciation/appreciationCourses/appreciationCoursesEditForm";
	}

	@RequiresPermissions("appreciation:appreciationCourses:edit")
	@PostMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(AppreciationCourses appreciationCourses) {
		try {
			restBeanValidator(appreciationCourses);
			appreciationCoursesService.validateParam(appreciationCourses);
			appreciationCoursesService.validateBusiness(appreciationCourses);
			if (StringUtils.isBlank(appreciationCourses.getId())) {
				//添加
				appreciationCoursesService.addCourses(appreciationCourses);
			} else {
				//编辑
				appreciationCoursesService.save(appreciationCourses);
			}
		} catch (ZAException e) {
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, e.getMessage());
		}
		return ResultDto.success(appreciationCourses.getId());
	}

	@RequiresPermissions("appreciation:appreciationCourses:del")
	@RequestMapping(value = "delete")
	public String delete(AppreciationCourses appreciationCourses, RedirectAttributes redirectAttributes) {
		try {
			appreciationCoursesService.deleteCourses(appreciationCourses);
			addMessage(redirectAttributes, "删除课程成功");
		} catch (ZAException e) {
			addMessage(redirectAttributes, "删除课程失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationCourses/?repage";
	}

	@RequiresPermissions("appreciation:appreciationCourses:end")
	@RequestMapping(value = "end")
	public String endCourses(AppreciationCourses appreciationCourses, RedirectAttributes redirectAttributes) {
		try {
			appreciationCoursesService.endCourses(appreciationCourses);
			addMessage(redirectAttributes, "结束课程成功");
		} catch (ZAException e) {
			addMessage(redirectAttributes, "结束课程失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/appreciation/appreciationCourses/?repage";
	}

	@RequiresPermissions("appreciation:appreciationCourses:export")
	@RequestMapping(value = "export")
	public void export(AppreciationCourses appreciationCourses, HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			appreciationCoursesService.export(appreciationCourses, response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出信息失败！失败信息：" + e.getMessage());
		}
	}

	@RequiresPermissions("appreciation:appreciationCourses:rel")
	@RequestMapping(value = "coursewareForm")
	public String coursewareRelForm(AppreciationCourses appreciationCourses, Model model) {
		model.addAttribute("appreciationCourses", appreciationCourses);
		return "oa/appreciation/appreciationCourses/appreciationCoursewareRelForm";
	}

	@RequiresPermissions("appreciation:appreciationCourses:rel")
	@PostMapping(value = "coursesCoursewareRel")
	@ResponseBody
	public ResultDto<String> coursesCoursewareRef(CoursesCoursewareRefRequest request) {
		try {
			//添加关联关系
			appreciationCoursesCoursewareRefService.relCoursesCourseware(request);
		} catch (ZAException e) {
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, e.getMessage());
		}
		return ResultDto.success(request.getCourseId());
	}
}