package com.cku.cab.editor.groomervenue.service;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.CycleDetectionStrategy;

import com.cku.cab.editor.groomervenue.entity.GroomerVenue;
import com.cku.cab.editor.groomervenue.entity.RestfulGroomerVenue;
import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.cab.editor.groomervenue.dao.GroomerVenueDao;

/**
 * 美容场馆Service
 * @author zhuoHeng
 * @version 2016-11-25
 */
@Service
@Transactional(readOnly = true)
public class GroomerVenueService extends CrudService<GroomerVenueDao, GroomerVenue> {

	public GroomerVenue get(String id) {
		return super.get(id);
	}
	
	public List<GroomerVenue> findList(GroomerVenue groomerVenue) {
		return super.findList(groomerVenue);
	}
	
	public Page<GroomerVenue> findPage(Page<GroomerVenue> page, GroomerVenue groomerVenue) {
		return super.findPage(page, groomerVenue);
	}
	
	@Transactional(readOnly = false)
	public void save(GroomerVenue groomerVenue) {
		super.save(groomerVenue);
	}
	
	@Transactional(readOnly = false)
	public void delete(GroomerVenue groomerVenue) {
		super.delete(groomerVenue);
	}

	
	/**
	 * 
	 * @Description：美容场馆
	 * @author: zhuoHeng
	 * @version: 2016年11月28日 上午10:43:17
	 */
	public RESTResponse getVenue(HttpServletRequest request) {
		
		String id = request.getParameter("id");
		GroomerVenue model = super.get(id);
		RestfulGroomerVenue vo = new RestfulGroomerVenue();
		BeanUtil.copyProperties(vo, model, "yyyy-MM-dd");
		
		return new RESTResponse("data", vo);
	}
	
}