package com.initSplit;


import com.cku.oa.statistics.service.CheckSplitFinanceService;
import com.cku.oa.statistics.service.NewSplitFinanceService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration({"classpath*:/spring-context*.xml"})
public class NewSplitFinanceController {
	@Autowired
	private NewSplitFinanceService newSplitFinanceService;
	@Autowired
	private CheckSplitFinanceService checkSplitFinanceService;

	private final String startDateStr = "2025-07-01 00:00:00";
	private final String endDateStr = "2025-07-31 23:59:59";
	private final String memberTableName = "sys_member_20250801";

	@Test
	public void testInitSplit() {
		newSplitFinanceService.initSplit(startDateStr, endDateStr, 2025);
	}

	@Test
	public void testCheckFinance() {
		checkSplitFinanceService.checkFinance(startDateStr, endDateStr);
	}


//    @Test
//    public void testCheckFinanceMatch(){
//        checkSplitFinanceService.checkFinanceMatch("221","2017-01-01 00:00:00","2017-11-30 23:59:59");
//    }


	@Test
	public void testSumInstallmentBalance() {
		checkSplitFinanceService.testSumInstallmentBalance(endDateStr, memberTableName);
	}
//    @Test
//    public void testOldFinance() throws DateParseException {
//        Date forM = YearToMonthSplitUtils.getBeforeDate(DateUtil.parseDate("2018-03-07 00:00:00"),DateUtil.parseDate("2018-03-06 19:42:24"));
//        System.out.println(DateUtil.formatDate(forM));
//    }
}
