var util = {};
util.baseUrl = "http://vip.chongaibao.com/oa-web/";
util.setLSItem = function (key, value) {
	localStorage.setItem(key, value);
};
util.getLSItem = function(key){
	return localStorage.getItem(key);
};
util.setSSItem = function (key, value) {
    sessionStorage.setItem(key, value);
};
util.getSSItem = function (key) {
    return sessionStorage.getItem(key);
};
//检查配种证明cku,ckutm开头
util.checkIsCKU = function(val){
	var result = 0;
	val = val.toUpperCase();
	var ckuStr = val.substr(0,3);
	var ckutmStr = val.substr(0,5);
	if(ckuStr=="CKU"){
		result=1;
	}
	if(ckutmStr=="CKUTM"){
		result=1;
	};
	return result;

};
//检查犬主变更cku开头
util.checkIsCKUAll = function(val){
	var result = 0;
	val = val.toUpperCase();
	var ckuStr = val.substr(0,3);
	var ckutmStr = val.substr(0,5);
	if(ckuStr=="CKU"){
		result=1;
	}
	return result;

};
/**
 *判断是否是空
 * @param val
 * @returns {*}
 */
util.isVal = function (val){
	if(val == null || val == undefined || val == "" || val==NaN){
		return "";
	}else{
		if((typeof str)=='string'){
			val = val.replace(/(^\s+)|(\s+$)/g,"");
		}
		return val;
	}
};
util.isEmail = function(val) {
	var str = val.trim();
	if(str.length!=0){
		reg=/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
		if(!reg.test(str)){
			return false;
		}else{
			return true;
		}
	}else{
		return false;
	}
}
util.isMobile = function(val) {
	var str = val.trim();
	if(str.length!=0){
		reg= /^[0-9]*$/;
		var aomenReg=/^((((0?)|((00)?))(((\s){0,2})|([-_－—\s]?)))|([+]?))(853)?([]?)([-_－—\s]?)(28[0-9]{2}|((6|8)[0-9]{3}))[-_－—\s]?[0-9]{4}$/;
		var taiwanReg=/^([-_－—\s\(]?)([\(]?)((((0?)|((00)?))(((\s){0,2})|([-_－—\s]?)))|(([\)]?)[+]?))(886)?([\)]?)([-_－—\s]?)([\(]?)[0]?[1-9]{1}([-_－—\s\)]?)[1-9]{2}[-_－—]?[0-9]{3}[-_－—]?[0-9]{3}$/;
		var xianggangReg=/^((((0?)|((00)?))(((\s){0,2})|([-_－—\s]?)))|(([(]?)[+]?))(852)?([)]?)([-_－—\s]?)((2|3|5|6|9)?([-_－—\s]?)\d{3})(([-_－—\s]?)\d{4})$/;
		if(reg.test(str)||taiwanReg.test(str)||xianggangReg.test(str)||aomenReg.test(str)){
			return true;
		}else{
			return false;
		}
	}else{
		return false;
	}
}
//去掉所有空格
util.removeg = function(val){
	return val.replace(/\s/g, ""); 
}
util.isCardNo = function(val) {
	var str = val.trim();
	if(str.length!=0){
		var reg= /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
		var taiwanreg=/^[a-zA-Z]{1}[0-9]{9}$/;
		var xianggangreg=/^((\s?[A-Za-z])|([A-Za-z]{2}))\d{6}(([0−9aA])|([0-9aA]))$/;
		var aomenreg=/^[1|5|7][0-9]{6}\([0-9Aa]\)/;
		if(reg.test(str)||taiwanreg.test(str)||xianggangreg.test(str)||aomenreg.test(str)){
			return true;
		}else{
			return false;
		}
	}else{
		return false;
	}
}
util.isZhWord = function(val){
	var str = val.trim();
	if(str.length!=0){
		reg= /[^\u4e00-\u9fa5]/g;
		if(!reg.test(str)){
			return false;
		}else{
			return true;
		}
	}else{
		return false;
	}
}
util.isEnWord = function(val){
	var str = val.trim();
	if(str.length!=0){
		reg= /^[A-Za-z\s]+$/;
		if(!reg.test(str)){
			return false;
		}else{
			return true;
		}
	}else{
		return false;
	}
}
/**
 * ajax 封装
 *
 */
util.sendAjax = function(obj) {
	var baseUrl = "/oa-web/api/v1/";
	var url = baseUrl+obj.url;
	var data = obj.data;
	var async = obj.async;
	var loadFlag = obj.loadFlag;
	var type = obj.type;
	var cache = obj.cache;
	var successfn = obj.success;
	var errorfn = obj.error;
	async = (async==null || async==="" || typeof(async)=="undefined")? "true" : async;
	cache = (cache==null || cache==="" || typeof(cache)=="undefined")? "false" : cache;
	type = (type==null || type==="" || typeof(type)=="undefined")? "GET" : type.toLocaleUpperCase();
	data = (data==null || data==="" || typeof(data)=="undefined")? {"date": new Date().getTime()} : data;
	//POST,PUT 转化成json字符串
	if(type=="POST" || type=="PUT"){

	}
	$.ajax({
		type: type,
		async: async,
		data: data,
		url: url,
		cache: cache,
		contentType : "application/json;charset=UTF-8",
		dataType: 'json',
		timeout:30000,
		beforeSend: function(XMLHttpRequest){
			layer.open({type: 2});
		},
		success: function(json){
			layer.closeAll();
			successfn(json);
		},
		error: function(XMLHttpRequest, status, error){
			layer.closeAll();
			if(XMLHttpRequest.status == 401){
				window.location.href = "login.html";
				return;
			}
			layer.open({
				content: "网络连接错误!"
				,skin: 'msg'
				,time: 2 //2秒后自动关闭
			});
			if(util.isVal(errorfn)==""){
				return;
			}
			errorfn(XMLHttpRequest, status, error);
		},
		complete :function(XMLHttpRequest, TS){
		}
	});
};

util.formatDateShort = function(str) {
	var now = null;
	if(typeof str =="string"){
		now = new Date(str);
		if(now=="Invalid Date"){
			now  = new Date(str.replace(/-/g,"/"));
		}
	}else{
		now = str;
	}
	var year=now.getFullYear();
	var month=now.getMonth()+1;
	var date=now.getDate();
	return year+"-"+util.formatTwoLength(month)+"-"+util.formatTwoLength(date);
}
util.formatDateLong = function(str) {
	var now = null;
	if(typeof str =="string"){
		now = new Date(str);
		if(now=="Invalid Date"){
			now  = new Date(str.replace(/-/g,"/"));
		}
	}else{
		now = str;
	}
	var year=now.getFullYear();
	var month=now.getMonth()+1;
	var date=now.getDate();
	var hour=now.getHours();
	var minute=now.getMinutes();
	var second=now.getSeconds();
	return year+"-"+util.formatTwoLength(month)+"-"+util.formatTwoLength(date)+" "+util.formatTwoLength(hour)+":"+util.formatTwoLength(minute)+":"+util.formatTwoLength(second);
}
util.getOrderCode = function() {
	var now  = new Date();
	var year=now.getFullYear()+"";
	year = year.substring(2,4);
	var month=now.getMonth()+1;
	var date=now.getDate();
	var hour=now.getHours();
	var minute=now.getMinutes();
	var second=now.getSeconds();
	var ms = now.getMilliseconds();
	return year+""+util.formatTwoLength(month)+""+util.formatTwoLength(date)+""+util.formatTwoLength(hour)+""+util.formatTwoLength(minute)+""+util.formatTwoLength(second)+util.formatTwoLength(ms);
}
util.formatTwoLength = function(str){
	str = str+"";
	if(str.length>2){
		str = str.substring(0,2);
	}
	if(str.length==1){
		str = "0"+str;
	}

	return str;
}
util.getQueryString = function() {
	   var url = location.href; //获取url中"?"符后的字串
		url = decodeURI(url);
	   var theRequest = new Object();   
	   if (url.indexOf("?") != -1) {
		   url = url.substring(url.indexOf("?")+1);
	      var str = url;
	      strs = str.split("&");   
	      for(var i = 0; i < strs.length; i ++) {   
	         theRequest[strs[i].split("=")[0]]=unescape(strs[i].split("=")[1]);   
	      }   
	   }   
	   return theRequest;  
   };

/**
 * 将form表单转化为json
 * @param frm
 * @returns {{}}
 */
util.getFormJson=function(frm) {
	var o = {};
	var a = $(frm).serializeArray();
	$.each(a, function () {
		if (o[this.name] !== undefined) {
			if (!o[this.name].push) {
				o[this.name] = [o[this.name]];
			}
			o[this.name].push(this.value || '');
		} else {
			o[this.name] = this.value || '';
		}
	});

	return o;
}
/**
 *截止时间
 */
util.endTime = function(durTime){
	var day = 0;
	var hour = 0;
	var min = 0;
	if(durTime>=24*60*60*1000){
		day = Math.floor(durTime/(24*60*60*1000));
		durTime = durTime-(day*24*60*60*1000);
		hour = Math.floor(durTime/(60*60*1000));
		durTime = durTime-(hour*60*60*1000);
		min = Math.floor(durTime/(60*1000));
	}else if(durTime>=60*60*1000){
		hour = Math.floor(durTime/(60*60*1000));
		durTime = durTime-(hour*60*60*1000);
		min = Math.floor(durTime/(60*1000));
	}else if(durTime>=0){
		min = Math.floor(durTime/(60*1000));
	}
	return day+"天"+hour+"小时"+min+"分";
};





