//犬主变更申请列表
/**
 * 犬主变更查询
 * */
function finddogOwnerChangeList(page){
    var sendData = {};
    //检测是芯片号还是血统号
    var str = $("#zsid").val().trim();
    sendData["pedigreeCertifiedCode"] = str;
    sendData["pageSize"] = "10";
    sendData["pageNo"] = page;
    util.sendAjax({
        url:'dog/dogownerchange',
        data:sendData,
        async:false,
        type:'GET',
        cache:false,
        success:function(data){
            if(data.rc==0){
                if(data.list!=null && data.list.length>0){
                    var member = userInfo.getMember();
                    $("#dogOwnerChangeList").html("");
                    $.each(data.list,function(index,item){
                        $("#dogOwnerChangeList").append("<tr>"
                            +"<td>"+item.pedigreeCertifiedCode+"</td>"
                            +"<td>"+item.newOwnerName+"</td>"
                            +"<td>"+item.reviewer+"</td>"
                            +"<td class='reviewState'>"+item.reviewState+"</td>"
                            +"</tr>");
                        if(item.reviewState!="通过"){
                            if(item.reviewState=="不通过"||item.reviewState=="未通过"){
                                $(".reviewState").eq(index).css("color","#F00");
                            }else if(item.reviewState=="待审核"||item.reviewState=="未审核"){
                                $(".reviewState").eq(index).css("color","#329a40");
                            }
                            if((member.memberCode==item.originOwnerMemberCode && item.reviewState==("未通过"||"不通过"))||(item.reviewState=="未审核"||item.reviewState=="待审核")){
                                $(".reviewState").eq(index).on("click",function(){
                                    getMsg(item.id);
                                    $("#changeMsg").show();
                                })
                            }else if(item.reviewState=="未通过"){
                                $(".reviewState").eq(index).on("click",function(){
                                    layer.open({
                                        title:['未通过原因：','text-align:left;font-size:14px;'],
                                        content:item.reviewRemarks,
                                        btn:["关闭"]
                                    })
                                })
                            }
                        }
                    })
                    initPage(page,10,data.total);
                }else{
                    $("#dogOwnerChangeList").html("");
                    layer.open({
                        content:"犬主变更申请列表为空！",
                        skin:"msg",
                        time:2
                    })
                    initPage(page,10,1);
                }
            }else{
                layer.open({
                    content:"查询失败："+data.msg,
                    skin:"msg",
                    time:2
                })
            }
        }
    });
}
//审核信息
function getMsg(id){
    util.sendAjax({
        url:'dog/dogownerchange/'+id,
        data:{},
        async:true,
        loadFlag:true,
        type:'GET',
        cache:false,
        success:function(json){
            if(json.rc==0){
                $("#reviewRemarks").val(json.data.reviewRemarks)
                $("#changeDogInfo").html("<span class='blockline'>血统证书号："+json.data.pedigreeCertifiedCode+"</span>"
                    +"<span class='blockline'>犬只姓名："+json.data.nameEn+"</span>"
                    +"<span class='blockline'>犬只性别："+json.data.gender+"</span>"
                    +"<span class='blockline'>犬只出生日期："+json.data.birthdate+"</span>"
                    +"<span class='blockline'>犬只芯片号："+json.data.identificationFlag+"</span>"
                    +"<span class='blockline'>原犬主会员号："+json.data.originOwnerMemberCode+"</span>"
                    +"<span class='blockline'>原犬主姓名："+json.data.originOwnerName+"</span>"
                    +"<span class='blockline'>新犬主会员号："+json.data.newOwnerMemberCode+"</span>"
                    +"<span class='blockline'>新犬主姓名："+json.data.newOwnerName+"</span>"
                    +"<span class='blockline'>新犬主省市："+json.data.province+"-"+json.data.city+"</span>"
                    +"<span class='blockline'>新犬主手机号："+json.data.mobile+"</span>");
                $("#changeCofirm").on("click",function(){
                    confirmChange(json.data.id);
                })
            }else{
                layer.open({
                    content:"获取审核详情失败："+json.msg,
                    skin:"msg",
                    time:2
                })
            }
        }
    })
}
//关闭审核信息
function closeChange(){
    $("#changeMsg").hide();
}
//审核变更提交
function confirmChange(id){
    var sendData = {};
    sendData["id"] = id;
    var reviewState = $(":radio[name='ChangeAgree']:checked").val();
    sendData["reviewState"] = reviewState;
    sendData["reviewRemarks"] = $("#reviewRemarks").val().trim();
    if(reviewState=="1"){
        layer.open({
            content: "是否确认变更？一旦确认无法撤销！"
            ,btn: ['确定','关闭'] //按钮
            ,yes:function(index){
                util.sendAjax({
                    url:'dog/dogownerchange',
                    data:JSON.stringify(sendData),
                    async:true,
                    loadFlag:true,
                    type:'PUT',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            window.location.reload();
                        }else{
                            layer.open({
                                content:"审核提交失败:"+json.msg,
                                skin:"msg",
                                time:2
                            });
                        }
                    }
                });
            }
        });
    }else{
        util.sendAjax({
            url:'dog/dogownerchange',
            data:JSON.stringify(sendData),
            async:true,
            loadFlag:true,
            type:'PUT',
            cache:false,
            success:function(json){
                if(json.rc==0){
                    window.location.reload();
                }else{
                    layer.open({
                        content:"审核提交失败:"+json.msg,
                        skin:"msg",
                        time:2
                    });
                }
            }
        });
    };
}
//初始化分页
function initPage(nowPage,pageSize,total){
    var html="<div class=\"new-tbl-cell\"><a href=\"?page="+(nowPage==1?1:nowPage-1)+"\" class=\"new-a-prve\"><span>上一页</span></a></div>"+
        "<div class=\"new-tbl-cell new-p-re\"><div class=\"new-a-page\"><span class=\"new-open\">"+nowPage+"/"+Math.ceil(total/pageSize)+"</span></div>"+
        "<select class=\"new-select\" onchange=\"window.location.href=this.value;\">";
    for(var i=1;i<=Math.ceil(total/pageSize);i++){
        html+="<option value=\"?page="+i+"\" "+(nowPage==i?'selected':'')+">第"+i+"页</option>";
    }
    html+="</select></div><div class=\"new-tbl-cell\"><a class=\"new-a-next\" href=\"?page="+(nowPage==Math.ceil(total/pageSize)?nowPage:parseInt(nowPage)+1)+"\"><span>下一页</span></a></div>";
    $("#showPageContent").html(html);
}
$(function(){
    userInfo.refresh();
    var page =1;
    var obj = util.getQueryString();
    if(obj.page==undefined){
        page=1;
    }else{
        page=obj.page;
    }
    finddogOwnerChangeList(page);
})