require.config({
	baseUrl: 'scripts',
	paths: {
    "jquery": "lib/jquery-1.9.1",
    "jquery.cookie":"lib/jquery.cookie",
    "text": "lib/text",
    "knockout":"lib/knockout-3.1.0.debug",
    "ko-amd":"lib/knockout-amd-helpers",
    "sammy":"lib/sammy-0.7.4",
    "layer":"lib/layer/layer",
    "util":"lib/util",
    "My97DatePicker":"lib/My97DatePicker/WdatePicker",
    "loginapp":"modules/loginapp"
  },
  shim: {
    "jquery":{
      exports:"jquery"
    },
    "layer":{
      deps:["jquery"]
    },
    "jquery.pagination":{
      deps:["jquery"]
    },
    "sammy": {
      deps:["jquery"]
    }
  }
});

require(["knockout", "loginapp", "ko-amd","layer","util","jquery.cookie","My97DatePicker"], function(ko, loginapp){
	ko.bindingHandlers.module.baseDir = "modules";
	ko.amdTemplateEngine.defaultPath = "templates";
	ko.applyBindings(new loginapp());
});