//犬主变更添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.pedigreeCertifiedCode = ko.observable("");
        me.dogId = ko.observable("");
        //根据血统证书号查出来的狗信息
        me.mydog = ko.observable({});
        //获取价格
        me.showPrice = ko.observable("0");
        //是否展开注意事项
        me.isOpen = ko.observable(true);
        me.isShow = function(){
            me.isOpen(!me.isOpen());
        }
        /**
         * 我的犬只列表根据血统证书号查询
         */
        me.getDog = function(){
            if(me.pedigreeCertifiedCode()){
                var sendData = {};
                sendData["pedigreeCertifiedCode"] = me.pedigreeCertifiedCode();
                sendData["businessType"] = "0";
                util.sendAjax({
                    url:'dog/dogFrozenSemen/checkByPedigreeCertifiedCode',
                    data:sendData,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            if(json.data!=null){
                                me.mydog(json.data);
                                me.dogId(json.data.id);
                                me.getPrice();
                            }else{
                                layer.msg("查询信息失败，请输入正确的血统证书号！");
                                me.mydog({});
                                me.showPrice("0");
                            }
                        }else{
                            layer.msg("查询信息失败:"+json.msg);
                            me.mydog({});
                        }
                    }
                });
            }else{
                layer.msg("血统证书号不能为空！");
            }
        }
        //获取价格
        me.getPrice = function(){
            var sendData = {};
            sendData["businessType"] = "0";
            util.sendAjax({
                url:'dog/dogFrozenSemen/getPrice',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.showPrice(json.data.price);
                    }else{
                        layer.msg("获取价格失败:"+json.msg);
                    }
                }
            });
        }

        $(function(){
            var msg = "1、凯美洛公司建议进行冷冻精子保存的公犬年龄在2—6岁之间为最佳。</br>"
                    +"2、凯美洛公司建议首次计划冷冻精子保存的公犬，致电凯美洛预约精子质量鉴定，以评估该公犬是否适合冻精。</br>"
                    +"3、凯美洛公司建议公犬在进行冷冻精子保存之前完成至少一次布鲁氏杆菌测试，首次测试完成后的一个月，进行第二次测试，以确保测试的准确性。</br>"
                    +"4、请确认种犬适合冻精的情况下再进行DNA位点留存和精子的申报，以免造成不必要的损失。</br>";
            layer.alert(msg,{
                title:"重要提示"
                ,btn: ['我知道了']
                ,btnAlign: 'c'
            });
        });

        /**
         * 保存
         */
        me.saveCart = function(){
            var sendData = {};
            if(me.dogId()==''){
                layer.msg("请查询犬只信息后提交");
                return;
            }
            sendData["dogId"] = me.mydog().dogId;
            sendData["businessType"] = "0";
            util.sendAjax({
                url:'dog/dogFrozenSemen',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc ==0){
                        context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("种犬申报申请失败:"+json.msg);
                    }
                }
            });
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});