<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务提醒管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/remind/">业务提醒列表</a></li>
		<shiro:hasPermission name="sys:remind:edit"><li><a href="${ctx}/sys/remind/form">业务提醒添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="remind" action="${ctx}/sys/remind/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>主题：</label>
				<form:input path="content" htmlEscape="false" maxlength="300" class="input-medium"/>
			</li>
			<li><label>read_flag：</label>
				<form:input path="readFlag" htmlEscape="false" maxlength="1" class="input-medium"/>
			</li>
			<li><label>消息对应的用户id：</label>
				<sys:treeselect id="user" name="user.id" value="${remind.user.id}" labelName="user.name" labelValue="${remind.user.name}"
					title="用户" url="/sys/office/treeData?type=3" cssClass="input-small" allowClear="true" notAllowSelectParent="true"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>主题</th>
				<th>消息阅读的时间</th>
				<th>read_flag</th>
				<th>消息对应的用户id</th>
				<th>更新时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="sys:remind:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="remind">
			<tr>
				<td><a href="${ctx}/sys/remind/form?id=${remind.id}">
					${remind.content}
				</a></td>
				<td>
					<fmt:formatDate value="${remind.readDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${remind.readFlag}
				</td>
				<td>
					${remind.user.name}
				</td>
				<td>
					<fmt:formatDate value="${remind.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${remind.remarks}
				</td>
				<shiro:hasPermission name="sys:remind:edit"><td>
    				<a href="${ctx}/sys/remind/form?id=${remind.id}">修改</a>
					<a href="${ctx}/sys/remind/delete?id=${remind.id}" onclick="return confirmx('确认要删除该业务提醒吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>