<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬展委派记录管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#btnImport").click(function () {
                $.jBox($("#importBox").html(), {
                    title: "犬展委派记录导入", buttons: {"关闭": true},
                    bottomText: "导入文件不能超过3M，仅允许导入“xls”或“xlsx”格式文件！"
                });
            });

        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<div id="importBox" class="hide">
    <form id="importForm" action="${ctx}/show/delegateLog/import" method="post" enctype="multipart/form-data"
          class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
        <input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
        <input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
        <a href="${ctx}/show/delegateLog/import/template">下载模板</a>
    </form>
</div>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/show/delegateLog/">犬展委派记录列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="showRefereeDelegateLog" action="${ctx}/show/delegateLog/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>犬展编号：</label>
            <form:input path="mainShowId" htmlEscape="false" maxlength="32" class="input-small"/>
        </li>
        <li><label>裁判：</label>
            <form:input path="referees" htmlEscape="false" maxlength="255" class="input-medium"/>
        </li>
        <li><label>大区：</label>
            <form:select path="region" class="input-small required">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('show_region')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>省份：</label>
            <form:input path="province" htmlEscape="false" maxlength="32" class="input-small"/>
        </li>
        <li><label>城市：</label>
            <form:input path="city" htmlEscape="false" maxlength="32" class="input-small"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="犬展委派记录导入"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>犬展编号</th>
        <th>大区</th>
        <th>省份</th>
        <th>城市</th>
        <th>犬展开始时间</th>
        <th>犬展结束时间</th>
        <th>裁判</th>
        <shiro:hasPermission name="show:delegateLog:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="showRefereeDelegateLog">
        <tr>
            <td><a href="${ctx}/show/delegateLog/form?id=${showRefereeDelegateLog.id}">
                    ${showRefereeDelegateLog.mainShowId}
            </a></td>
            <td>

                    ${fns:getDictLabel(showRefereeDelegateLog.region, 'show_region', '')}
            </td>
            <td>
                    ${showRefereeDelegateLog.province}
            </td>
            <td>
                    ${showRefereeDelegateLog.city}
            </td>
            <td>
                <fmt:formatDate value="${showRefereeDelegateLog.startDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                <fmt:formatDate value="${showRefereeDelegateLog.endDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                    ${showRefereeDelegateLog.referees}
            </td>
            <td>
                <shiro:hasPermission name="show:delegateLog:edit">
                    <a href="${ctx}/show/delegateLog/form?id=${showRefereeDelegateLog.id}">修改</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="show:delegateLog:del">
                    <a href="${ctx}/show/delegateLog/delete?id=${showRefereeDelegateLog.id}"
                       onclick="return confirmx('确认要删除该犬展委派记录吗？', this.href)">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>