<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>地方办公室管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show/showOffice/">地方办公室列表</a></li>
		<shiro:hasPermission name="show:showOffice:add"><li><a href="${ctx}/show/showOffice/form">地方办公室添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showOffice" action="${ctx}/show/showOffice/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="20" class="input-medium"/>
			</li>
			<li><label>负责人：</label>
				<form:input path="manager" htmlEscape="false" maxlength="10" class="input-medium"/>
			</li>
			<li><label>联系电话：</label>
				<form:input path="phone" htmlEscape="false" maxlength="20" class="input-medium"/>
			</li>
			<li><label>办公电话：</label>
				<form:input path="officePhone" htmlEscape="false" maxlength="40" class="input-medium"/>
			</li>
			<li><label>地址：</label>
				<form:input path="address" htmlEscape="false" maxlength="200" class="input-medium"/>
			</li>
			<li><label>邮编：</label>
				<form:input path="zipCode" htmlEscape="false" maxlength="6" class="input-medium"/>
			</li>
			<li><label>负责区域：</label>
				<form:input path="responsibleArea" htmlEscape="false" maxlength="200" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>名称</th>
				<th>负责人</th>
				<th>联系电话</th>
				<th>办公电话</th>
				<th>地址</th>
				<th>邮编</th>
				<th>负责区域</th>
				<shiro:hasPermission name="show:showOffice:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showOffice">
			<tr>
				<td>
					<a href="${ctx}/show/showOffice/form?id=${showOffice.id}">${showOffice.name}</a>
				</td>
				<td>
					${showOffice.manager}
				</td>
				<td>
					${showOffice.phone}
				</td>
				<td>
					${showOffice.officePhone}
				</td>
				<td>
					${showOffice.address}
				</td>
				<td>
					${showOffice.zipCode}
				</td>
				<td>
					${showOffice.responsibleArea}
				</td>
				<td>
					<shiro:hasPermission name="show:showOffice:edit">
						<a href="${ctx}/show/showOffice/form?id=${showOffice.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="show:showOffice:del">
						<a href="${ctx}/show/showOffice/delete?id=${showOffice.id}"
						   onclick="return confirmx('确认要删除该犬展办公室吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>

			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>