<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8">
<title>犬展报名导出</title>
	<link rel="stylesheet" href="/oa-web/static/bootstrap/2.3.1/css_cerulean/bootstrap.min.css">
	<link rel="stylesheet" href="/oa-web/static/My97DatePicker/skin/WdatePicker.css">
	<style>
  		th{font-family:'黑体';}
	</style>
    <script src="/oa-web/static/jquery/jquery-1.10.2.min.js" type="text/javascript"></script>
    <script src="/oa-web/static/My97DatePicker/WdatePicker.js" type="text/javascript"></script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
    <script>
        function check() {
            var closingTimeFrom = $("input[name='closingTimeFrom']").val();
            var closingTimeTo = $("[name='closingTimeTo']").val();
            var closingTime = $("[name='closingTime']").val();
            var file = $("[name='file']").val();
            if (closingTimeFrom == null || closingTimeFrom == '') {
                alert("犬展起始时间不能为空");
                return false;
            }
            if (closingTimeTo == null || closingTimeTo == '') {
                alert("犬展结束时间不能为空");
                return false;
            }
            if (closingTime == null || closingTime == '') {
                alert("犬展活动区域间隔时间不能为空");
                return false;
            }
            if (typeof closingTime !== 'number' && closingTime % 1 !== 0) {
                alert("犬展活动区域间隔时间只能为整数");
                return false;
            }
            if (file == null || file == '') {
                alert("上传文件不能为空");
                return false;
            }
            return true;
        }
        function groupByShowApply() {
            var showCodePrefix = ${param.showCodePrefix};
            $.post('${ctx}/apply/showApply/groupByShowApply', {
                showCodePrefix: showCodePrefix
            }, function (data) {
                console.log(data)
            });
        }
        function showApplyConflict() {
            var showCodePrefix = ${param.showCodePrefix};
            $.post('${ctx}/apply/showApply/showApplyConflict', {
                showCodePrefix: showCodePrefix
            }, function (data) {
                console.log(data)
            });
        }
        $(function () {
//	edit();
        });
        function remark() {
            var th = "<th>备注</th>";
            var td = "<td>待编辑</td>";
            $("tbody tr").append(td);
            $("thead tr").append(th);
            edit();
        }
        function edit() {
            $('tbody tr td').click(function () {
                var type = $(this).data("type");
                var thisclass = $(this).parent().attr("class");
                if (thisclass != "warning") {
                    if (!$(this).is('.input')) {
                        $(this).addClass('input').html('<input style="width:100%;" type="text" value="' + $(this).text() + '" />').find('input').focus().blur(function () {
                            var thisid = $(this).parent().siblings("td:eq(0)").text();
                            var thisvalue = $(this).val();
                            /* $.ajax({
                             type: 'POST',
                             url: '/oa-web/oaManage/apply/showApply',
                             data: "id="+thisid+"&"+type+"="+thisvalue
                             }); */
                            $(this).parent().removeClass('input').html($(this).val() || 0);
                        });
                    }
                }
            }).hover(function () {
                $(this).addClass('hover');
            }, function () {
                $(this).removeClass('hover');
            });
        }
    </script>
</head>
  <body>
	  <form id="searchForm" action="/oa-web/oaManage/apply/showApply/getExportlist" method="post"
			class="breadcrumb form-search" style="margin-bottom: 0px">
		  <ul>
			  <li class="btns">
				  <input type="text" name="showCodePrefix" value="${param.showCodePrefix}">
				  <input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
				  <%--<input class="btn btn-primary" type="button" value="分组" onClick ="groupByShowApply()"/>--%>
				  <%--<input class="btn btn-primary" type="button" value="重复人员" onClick ="showApplyConflict()"/>--%>
				  <a class="btn btn-primary" style="color: #fff; font-size: 12px;"
					 href="/oa-web/oaManage/apply/showApply/exportBs?showCodePrefix=${param.showCodePrefix}">导出原始EXCEL</a>
				  只有犬展报名已截止后才能导出数据
			  </li>
		  </ul>
	  </form>
	  <form id="importForm" action="/oa-web/oaManage/apply/showApply/exportScoreBlank" method="post"
			enctype="multipart/form-data" class="breadcrumb form-search">
		  <ul>
			  <li class="btns">
				  <input type="hidden" name="showCodePrefix" value="${param.showCodePrefix}">
				  <input id="uploadFile" name="file" type="file" style="width:230px"/>　
				  <input id="btnImportSubmit" class="btn btn-primary" type="submit" value="导出空白成绩EXCEL"/>
				  如不需重新排序或处理数据，可直接导出
			  </li>
		  </ul>
	  </form>
      <div class="pre-scrollable" style="max-height:800px;">
          <table id="customers" class="table table-bordered" style="min-width:1500px; white-space: nowrap;">
              <thead>
              <tr class='warning' bgcolor="#2fa4e7" style="color:#ffffff;">
                  <td style="display: none;font-family:'黑体';">id</td>
                  <th>ID</th>
                  <th>犬展编号</th>
                  <th>犬主人</th>
                  <th>犬主名(牵犬人名)</th>
                  <th>姓名拼音</th>
                  <th>会员号</th>
                  <th>备注</th>
                  <th>第2犬主姓名</th>
                  <th>第2犬主会员号</th>
                  <th>犬种中文名</th>
                  <th>犬种英文名</th>
                  <th>OAFCI码</th>
                  <th>犬种组</th>
                  <th>犬名</th>
                  <th>性别</th>
                  <th>代数</th>
                  <th>是否满足三代</th>
                  <th>出生日期</th>
                  <th>年龄组别</th>
                  <th>秩序册上场顺序码</th>
                  <th>全部年龄组别</th>
                  <th>CKU血统证书号</th>
                  <th>国外血统证书号</th>
                  <th>芯片号</th>
                  <th>父犬血统证书号</th>
                  <th>父犬名</th>
                  <th>母犬血统证书号</th>
                  <th>母犬名</th>
                  <th>繁殖人</th>
                  <th>参展人</th>
                  <th>报名序号</th>
                  <th>BBE</th>
                  <th>实收金额</th>
                  <th>联系方式</th>
                  <th>提交日期</th>
                  <th>毛色</th>
                  <th>牵犬师姓名</th>
                  <th>牵犬师会员号</th>
              </tr>
              </thead>
              <tbody>
              <c:forEach items="${list}" var="results" varStatus="status">
                  <c:choose>
                      <c:when test="${results.isPassReason == ''}">
                          <tr>
                      </c:when>
                      <c:otherwise>
                          <tr style="color:${results.reasonColor}" title="${results.isPassReason}">
                      </c:otherwise>
                  </c:choose>
                  <td data-type="id" style="display: none;">${results.id}</td>
                  <td data-type="">${status.index + 1}</td>
                  <td data-type="showCode">${results.showCode}</td>
                  <td data-type="dogOwnerNameCn">${results.dogOwnerNameCn}</td>
                  <td data-type="dogOwnerAndHandler">${results.dogOwnerAndHandler}</td>
                  <td data-type="dogOwnerNameEn">${results.dogOwnerNameEn}</td>
                  <td data-type="dogOwnerMemberCode">${results.dogOwnerMemberCode}</td>
                  <td data-type="remarks">${results.remarks}</td>
                  <td data-type=secondDogOwner>${results.secondDogOwner}</td>
                  <td data-type="secondOwnerMember">${results.secondOwnerMember}</td>
                  <td data-type="dogBreedNameCn">${results.dogBreedNameCn}</td>
                  <td data-type="dogBreedNameEn">${results.dogBreedNameEn}</td>
                  <td data-type="fciCode">${results.fciCode}</td>
                  <td data-type="dogBreedGroup">${results.dogBreedGroup}</td>
                  <td data-type="dogName">${results.dogName}</td>
                  <td data-type="dogGender">${results.dogGender}</td>
                  <td data-type="dogGeneration">${results.dogGeneration}</td>
                  <td data-type="">${results.dogGenerationFlag}</td>
                  <td data-type="dogBirthday"><fmt:formatDate value="${results.dogBirthday}" pattern="yyyy-MM-dd"/></td>
                  <td data-type="ageGroup">${results.ageGroup}</td>
                  <td data-type="">${results.ageGroupFci}</td>
                  <td data-type="">${results.ageGroupCn}</td>
                  <td data-type="pedigreeCertified">${results.pedigreeCertified}</td>
                  <td data-type="otherCertified">${results.otherCertified}</td>
                  <td data-type="chipCode">${results.chipCode}</td>
                  <td data-type="fdogPedigreeCertified">${results.fdogPedigreeCertified}</td>
                  <td data-type="fdogName">${results.fdogName}</td>
                  <td data-type="mdogPedigreeCertified">${results.mdogPedigreeCertified}</td>
                  <td data-type="mdogName">${results.mdogName}</td>
                  <td data-type="breeder">${results.breeder}</td>
                  <td data-type="">${results.handlerMemberName}</td>
                  <td data-type="applyCode">${results.applyCode}</td>
                  <td data-type="bbeFlag">${results.bbeFlag}</td>
                  <td data-type="paymentAmount">${results.paymentAmount}</td>
                  <td data-type="contact">${results.contact}</td>
                  <td data-type="createDateExcelField"><fmt:formatDate value="${results.createDateExcelField}"
                                                                       pattern="yyyy-MM-dd"/></td>
                  <td data-type="colorFlag">${results.colorFlag}</td>
                  <td data-type="handlerMemberNameTemp">${results.handlerMemberNameTemp}</td>
                  <td data-type="handlerMemberCode">${results.handlerMemberCode}</td>
                  </tr>
              </c:forEach>
              </tbody>
          </table>
      </div>
</body>
</html>