<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>赛事顾问管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/show/showAdvisor/">赛事顾问列表</a></li>
		<shiro:hasPermission name="show:showAdvisor:add"><li><a href="${ctx}/show/showAdvisor/editForm">赛事顾问添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showAdvisor" action="${ctx}/show/showAdvisor/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>姓名</th>
				<th>姓名-英文</th>
				<th>从业时间</th>
				<th>担任轮值顾问年</th>
				<th>头衔</th>
				<th>犬舍名称</th>
				<th>繁殖品种</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showAdvisor">
			<tr>
				<td>
					${showAdvisor.name}
				</td>
				<td>
					${showAdvisor.nameEn}
				</td>
				<td>
					${showAdvisor.involvedInto}
				</td>
				<td>
					${showAdvisor.electedInto}
				</td>
				<td>
					${showAdvisor.title}
				</td>
				<td>
					${showAdvisor.kennelName}
				</td>
				<td>
					${showAdvisor.breedType}
				</td>
				<td>
				<shiro:hasPermission name="show:showAdvisor:view">
					<a href="${ctx}/show/showAdvisor/viewForm?id=${showAdvisor.id}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="show:showAdvisor:edit">
    				<a href="${ctx}/show/showAdvisor/editForm?id=${showAdvisor.id}">修改</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="show:showAdvisor:del">
					<a href="${ctx}/show/showAdvisor/delete?id=${showAdvisor.id}" onclick="return confirmx('确认要删除该赛事顾问吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>