<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>积分榜牵犬师管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				rules:{
					memberCode:{
						required:true
					},
					name:{
						required:true
					}
				}, 
				 messages:{
					memberCode:{
						required:"会员号不能为空"
					},
					name:{
						required:"姓名不能为空"
					}
				}, 
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});

		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}
		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#memberCode").val(json.memberCode);
			$("#name").val(json.name);
		}
		
		
		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/handler/showHandler/">积分榜牵犬师列表</a></li>
		<li class="active"><a href="${ctx}/handler/showHandler/form?id=${showHandler.id}">积分榜牵犬师<shiro:hasPermission name="handler:showHandler:edit">${not empty showHandler.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="handler:showHandler:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showHandler" action="${ctx}/handler/showHandler/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-xlarge "  readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<c:if test="${showHandler.id  == '' or showHandler.id  == null}">
					<input id="selectMember" class="btn btn-primary" value="查询"
					type="button" onclick="searchUser()" /> 
				</c:if>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge "  readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">照片：</label>
			<div class="controls">
				<sys:cropperImageUploadYun id="photo" label="请上传牵犬师照片"    url="${showHandler.photo}" 
					requestMapping="handlerRegister"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">简介：</label>
			<div class="controls">
				<form:textarea path="introduce" htmlEscape="false" rows="4" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="handler:showHandler:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>