<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>方案管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#quarterDiv").hide();
			$("#monthDiv").hide();
			$("#halfDiv").hide();
			
			$("#inputForm").validate({
				submitHandler: function(form){

					var type = $("#type").val();
					var year = $("[name='year']").val();
					var quarter = $("#quarter").val();
					var month = $("[name='month']").val();
					var half = $("#half").val();
					
					$.ajax({
						type: "POST",
		                dataType:"json",
		                url:"${ctx}/handler/refereeRankingSchem/schemCheck?type=" + type + "&year=" + year + "&quarter=" + quarter + "&month=" + month + "&half=" + half,
		                async: false,
		                success: function(data) {
		                	if(data.data != "OK"){
			                    var retVal = confirm("已有相同方案，继续添加将删除原有方案和数据");
			                	if(retVal == true){
			                		loading('正在提交，请稍等...');
			    					form.submit();
				                }
			                }else{
			                	loading('正在提交，请稍等...');
		    					form.submit();
				            }
		                }
					});
					
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			


			$("#type").on('change' , function(){
			     var value = $("#type").val();
			     if("1" == value){
			    	 $("#quarterDiv").hide();
					 $("#monthDiv").hide();
					 $("#halfDiv").hide();
				 }
				 if("2" == value){
					 $("#quarterDiv").show();
					 $("#monthDiv").hide();
					 $("#halfDiv").hide();
				 }
				 if("3" == value){
					 $("#quarterDiv").hide();
					 $("#monthDiv").show();
					 $("#halfDiv").hide();
			     }
			     if("4" == value){	
			    	 $("#quarterDiv").hide();
					 $("#monthDiv").hide();
					 $("#halfDiv").show();
				 }
			});
		});

		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/handler/refereeRankingSchem/">方案列表</a></li>
		<li class="active"><a href="${ctx}/handler/refereeRankingSchem/form?id=${refereeRankingSchem.id}">方案添加</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="refereeRankingSchem" action="${ctx}/handler/refereeRankingSchem/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		
		<div class="control-group">
			<label class="control-label">类型：</label>
			<div class="controls">
				<form:select id="type" path="type" class="input-medium required" >
	                <form:option value="" label="请选择"></form:option>
	                <form:options items="${fns:getDictList('referee_schem_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
	            </form:select>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">年份：</label>
			<div class="controls">
					<input name="year" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${year}" pattern="yyyy"/>"
					onclick="WdatePicker({dateFmt:'yyyy',isShowClear:true});"/>
			</div>
		</div>
	
		<div class="control-group" id="quarterDiv">
			<label class="control-label">季度：</label>
			<div class="controls">
				<form:select id="quarter" path="quarter" class="input-medium required" >
	                <form:option value="" label=""></form:option>
	                <form:options items="${fns:getDictList('quarter')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
	            </form:select>
			</div>
		</div>
		 
		<div class="control-group" id="monthDiv">
			<label class="control-label">月：</label>
			<div class="controls">
			<input name="month" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${month}" pattern="MM"/>"
					onclick="WdatePicker({dateFmt:'MM',isShowClear:true});"/>
			</div>
		</div>
		
		<div class="control-group" id="halfDiv">
			<label class="control-label">半年度：</label>
				<div class="controls">
			   <form:select id="half" path="half" class="input-medium required" >
	               <form:option value="" label="请选择"></form:option>
	               <form:option value="1" label="上半年"></form:option>
	               <form:option value="2" label="下半年"></form:option>
               </form:select>
               </div>
		</div>
		
		<div class="form-actions">
			<shiro:hasPermission name="handler:refereeRankingSchem:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>