<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>训练师电话报名录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
	$(document).ready(function() {
		$("#inputForm").validate({
			submitHandler: function(form){
				var memberCode=$("#memberCode").val();
				var showCode=$("#showCode").val();
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/handler/handlerRegister/registerCheck?showCode="+encodeURI(showCode, "UTF-8")+"&memberCode="+memberCode,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                    alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc == true){
	                		$.jBox.alert("您已经报名过了,请勿重复报名!","错误");
	                	}else{
	                		loading('正在提交，请稍等...');
	                		form.submit();
	                	}
	                }
				}); 
			},
			errorContainer: "#messageBox",
			errorPlacement: function(error, element) {
				$("#messageBox").text("输入有误，请先更正。");
				if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
					error.appendTo(element.parent().parent());
				} else {
					error.insertAfter(element);
				}
			}
		});
	});
		
	
		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">电话报名录入</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="handlerRegister" action="${ctx}/handler/handlerRegister/mobileFrom" method="post"
		class="form-horizontal">
		<input id="avatar" name="avatar" type="hidden">
		<sys:message content="${message}" />
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100"
					class="input-xlarge required" readonly="true" />
				<input id="selectMember" class="btn btn-primary" value="查询"
					type="button" onclick="searchUser()" /> 
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100"
					class="input-xlarge " readonly="true" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="100"
					class="input-xlarge " readonly="true" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">余额：</label>
			<div class="controls">
				<input type="text" readonly="readonly" id="accountBalance"
					class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input name="gender" maxlength="50" class="input-xlarge" type="radio" value="male" readonly="readonly" /> 
				<label>男</label> 
				<input name="gender" maxlength="50"  class="input-xlarge" type="radio" value="female" readonly="readonly" /> 
				<label>女</label>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">培训机构：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="100" class="input-xlarge required" />
				<ul>
					<li><font color="red">注:无培训机构,请填写'无'!</font></li>
				</ul>
			</div>
		</div>
		<div style="clear: both;"></div>
		<h3>赛事信息</h3>
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				<input value="${handlerShow.showName}" type="text"
					readonly="readonly" id="showName" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				<input id="showCode" name="showCode" type="text"
					value="${handlerShow.showCode}" class="input-xlarge required"
					readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				<input id="fee" name="fee" type="text" value="${handlerShow.fee}"
					class="input-xlarge required" readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">品种：</label>
			<div class="controls">
				<form:input path="anyBreed" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				<%--<input name="showLevel" maxlength="50" class="input-xlarge "  type="radio" <c:if test="${handlerShow.testLevel=='none' }">checked</c:if> value="none" />
				<label>无</label> --%>
				<input name="showLevel" maxlength="50" class="input-xlarge "   type="radio" value="C" />
				<label>C</label> 
				<input name="showLevel" maxlength="50" class="input-xlarge "  type="radio" value="B" />
				<label>B</label>
				<input name="showLevel" maxlength="50" class="input-xlarge "  type="radio" value="A" />
				<label>A</label> 
				<input name="showLevel" maxlength="50" class="input-xlarge "  type="radio" value="MASTER" />
				<label>教师</label>  
			</div>
		</div>
		<div id="showDog" class="control-group"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit"
				value="保 存" />&nbsp; <input id="btnCancel"
				class="btn" type="button" value="返 回" onclick="history.go(-1)" />
		</div>
	</form:form>
	<script>
		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}
		//var level = $("#showLevel").;
		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#memberCode").val(json.memberCode);
			$("#name").val(json.name);
            if(json.paymentState==2){
         	   $("#paymentState").text('有效');
            }else{
         	   $("#paymentState").text('无效');
            };
            $("#mobile").val(json.mobile);
            $("#avatar").val(json.avatar);
            $("#accountBalance").val(json.accountBalance);
            $("input[type=radio][name='gender'][value="+json.gender+"]").attr("checked",'checked');
            var memberCode=json.memberCode;

            var handlerShowId='${handlerShow.id}';
            $.ajax({
                type:"POST",
                url: ctx+"/handler/handlerRegister/getMemberMessage",
                data : {'memberCode':memberCode,'handlerShowId':handlerShowId},
                dataType: 'json',
                async: false, 
                success: function(jsons){
                	if (jsons.rc==0) {
                  		$("#schoolNameCn").val(jsons.schoolNameCn);
						var showType='${handlerShow.showType}';
						if(showType=='12' || showType=='13'){
							console.log(jsons);
							$("input[type=radio][name='showLevel'][value="+jsons.showLevel+"]").attr("checked",'checked');
						}
					}else{
                  		$.jBox.alert(jsons.msg,"提示");
						$("#memberCode").val('');
						$("#name").val('');
						$("#mobile").val('');
		           		$("#accountBalance").val('');
		           		$("#schoolNameCn").val('');
		          	    $("input[type=radio][name='gender']").removeAttr("checked");
					}
                }
            });  
		}
		

		function saveRegister(){
			
				$("#inputForm").submit();
			
		}
		
		
	</script>
</body>
</html>