<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>报名信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出报名信息数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/groomer/groomerRegister/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
			// 选择下拉列表
			var $select = $('#showCategoryClass');

			// 遍历所有的 <option> 元素
			$select.find('option').each(function() {
				// 检查 value 是否等于 5 为FCI增发类型，不展示
				if ($(this).val() === '5') {
					// 从下拉列表中移除该 <option>
					$(this).remove();
				}
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/groomer/groomerRegister/");
			$("#searchForm").submit();
        	return false;
        }
		
		//审核证件照
		function openLayer(id){
			top.layer.open({
				type: 2,
				title: ['证件照审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '400px'],
				content: "${ctx}/groomer/groomerRegister/uploadImage?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		
		//上传证件照
		function openLayer2(id){
			top.layer.open({
				type: 2,
				title: ['证件照上传', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '400px'],
				content: "${ctx}/groomer/groomerRegister/toUpImage?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		
		
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><shiro:hasPermission name="groomer:groomerShow:view"><a href="${ctx}/groomer/groomerShow/">活动管理</a></shiro:hasPermission></li>
		<li class="active"><a href="${ctx}/groomer/groomerRegister">报名信息管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerRegister" action="${ctx}/groomer/groomerRegister/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>报名序号：</label>
				<form:input path="registerCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium" style="width: 177px;">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium" style="width: 177px;">
					<form:option value="" label="全部"/>
					<form:option value="0" label="未审核"/>
					<form:option value="1" label="通过"/>
					<form:option value="2" label="未通过"/>
				</form:select>
			</li>
			<li>
				<label>会员有效状态：</label>
				<form:select path="member.paymentState" class="input-medium" style="width: 177px;">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>活动分类：</label>
				<form:select path="showCategory" id="showCategoryClass" class="input-medium" style="width: 177px;">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('groomer_show_category')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>活动类型：</label>
				<form:select path="groomerShow.showType" class="input-medium" style="width: 177px;">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_show_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>参赛级别：</label>
				<form:select path="showLevel" class="input-medium" style="width: 177px;">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>请假状态：</label>
				<form:select path="leaveCancel" class="input-medium" style="width: 177px;">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('leave_cancel')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<shiro:hasPermission name="groomer:groomerRegister:export"><button id="btnExport" type="button" class="btn btn-primary" >导出</button></shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>提交时间</th>
				<th>会员号</th>
				<th>有效期</th>
				<th>余额</th>
				<th>姓名</th>
				<th>美容师类型</th>
				<th>移动电话</th>
				<th>性别</th>
				<th>培训学校</th>
				<th>比赛品种</th>
				<th>赛事编号</th>
				<th>活动分类</th>
				<th>参赛级别</th>
				<shiro:hasPermission name="finance:deductCost:deductCost"><th>缴费</th></shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerRegister:audit"><th>照片</th></shiro:hasPermission> 
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerRegister">
			<tr>
				<td>
					${fns:escapeHtml(groomerRegister.registerCode)}
				</td>
				<td>
					<fmt:formatDate value="${groomerRegister.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td title='${fn:replace(groomerRegister.teamMemberCode, ",", "  ")}'>
					<a href="${ctx}/sys/user/member/form?id=${groomerRegister.member.id}">
					${fns:escapeHtml(groomerRegister.memberCode)}
					</a>
				</td>
				<td  style="color:${groomerRegister.member.paymentState=='2'?'#090':'#F00'}">
						${fns:getDictLabels(groomerRegister.member.paymentState, 'user_payment_state', '未缴费')}
				</td>
				<td>
						${groomerRegister.member.accountBalance }
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.name)}
				</td>
				<td>
					${fns:getDictLabels(groomerRegister.member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.member.mobile)}
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.member.gender, 'user_gender', '')}
				</td>
				<td>
					${fns:substringAfter(groomerRegister.schoolNameCn,",")}
				</td>
				<td>
					${fns:substringAfter(groomerRegister.showDogBreed,",")}
					${not empty groomerRegister.showDogBreedExtra?"# ":""}
					${fns:substringAfter(groomerRegister.showDogBreedExtra,",")}
				</td>
				<td>
					${fns:escapeHtml(groomerRegister.showCode)}
				</td>
				<td>
					${fns:getDictLabel(groomerRegister.groomerShow.showCategory, 'groomer_show_category', '')}
				</td>
				<td>
					<c:choose>
					    <c:when test="${groomerRegister.groomerShow.showCategory eq '4'}">
							${fns:getDictLabel(groomerRegister.showLevel, 'groomer_nurse_level', '')}
					    </c:when>
						<c:when test="${groomerRegister.groomerShow.showCategory eq '8'}">
							${fns:getDictLabel(groomerRegister.showLevel, 'groomer_cat_nurse_level', '')}
						</c:when>
					    <c:otherwise>
					    	${fns:getDictLabels(groomerRegister.showLevel, 'groomer_test_level', '')}
					    </c:otherwise>
					</c:choose>
				</td>
				<shiro:hasPermission name="finance:deductCost:deductCost">
				<td>
					<c:if test="${groomerRegister.groomerShow.showCategory=='1'}">
						<c:choose>
							<c:when test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='exam' }">
								<c:if test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='exam' && groomerRegister.showLevel=='MASTER' }">
									<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@10',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@10',1,'500','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
								</c:if>
								<c:if test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='exam' && groomerRegister.showLevel!='MASTER' }">
									<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@10',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@10',1,'${fns:escapeHtml(groomerRegister.fee) }','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
								</c:if>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='1' &&  groomerRegister.groomerShow.showType=='team' && groomerRegister.showLevel=='E'}">
								<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@E',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@E',1,'1200','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='1' &&  groomerRegister.groomerShow.showType=='team' && groomerRegister.showLevel=='F'}">
								<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@F',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@F',1,'900','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='1' &&  groomerRegister.groomerShow.showType=='match'}">
								<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@12',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@12',1,'${fns:escapeHtml(groomerRegister.fee) }','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='cathedra'}">
								<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@11',1,'0.00','${groomerRegister.memberCode}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@11',1,'${fns:escapeHtml(groomerRegister.fee) }','${groomerRegister.memberCode}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='cathedra'}">
								<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@11',1,'0.00','${groomerRegister.memberCode}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@11',1,'${fns:escapeHtml(groomerRegister.fee) }','${groomerRegister.memberCode}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='2'}">
								<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
							</c:when>
						</c:choose>
					</c:if>
					<c:if test="${groomerRegister.groomerShow.showCategory=='2'}">
						<c:choose>
							<c:when test="${groomerRegister.paymentState=='1'}">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@Inter',1,'${fns:escapeHtml(groomerRegister.fee) }','${groomerRegister.memberCode}')">
										${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='2'}">
								<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
							</c:when>
						</c:choose>

					</c:if>
					<c:if test="${groomerRegister.groomerShow.showCategory=='3'}">
						<c:choose>
							<c:when test="${groomerRegister.paymentState=='1'}">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@Pet',1,'${fns:escapeHtml(groomerRegister.fee) }','${groomerRegister.memberCode}')">
										${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='2'}">
								<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
							</c:when>
						</c:choose>
					</c:if>
					<c:if test="${groomerRegister.groomerShow.showCategory=='4'}">
						<c:choose>
							<c:when test="${groomerRegister.paymentState=='1'}">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@nurse_${groomerRegister.groomerShow.showType}',1,'${fns:escapeHtml(groomerRegister.fee) }','${groomerRegister.memberCode}')">
										${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='2'}">
								<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
							</c:when>
						</c:choose>
					</c:if>
					<c:if test="${groomerRegister.groomerShow.showCategory=='6'}">
						<c:choose>
							<c:when test="${groomerRegister.paymentState=='1'}">
								<a style="color:red" onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@pdg',1,'${fns:escapeHtml(groomerRegister.fee) }','${groomerRegister.memberCode}')">
										${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
								</a>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='2'}">
								<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
							</c:when>
						</c:choose>
					</c:if>
					<c:if test="${groomerRegister.groomerShow.showCategory=='7'}">
						<c:choose>
							<c:when test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='match' }">
								<c:choose>
									<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
										<a style="color:red"
										   onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@10',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
												${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
										</a>
									</c:when>
									<c:otherwise>
										<a style="color:red"
										   onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@fci_fee',1,'500','${fns:escapeHtml(groomerRegister.memberCode)}')">
												${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
										</a>
									</c:otherwise>
								</c:choose>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='2'}">
								<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
							</c:when>
						</c:choose>
					</c:if>
					<c:if test="${groomerRegister.groomerShow.showCategory=='8'}">
						<c:choose>
							<c:when test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='exam' }">
								<c:if test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='exam' && groomerRegister.showLevel=='MASTER' }">
									<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red"
											   onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@nurse_exam',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red"
											   onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@nurse_exam',1,'500.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
								</c:if>
								<c:if test="${groomerRegister.paymentState=='1' && groomerRegister.groomerShow.showType=='exam' && groomerRegister.showLevel !='MASTER' }">
									<c:choose>
										<c:when test="${groomerRegister.groomerShow.freeFee eq true }">
											<a style="color:red"
											   onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@nurse_exam',1,'0.00','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:when>
										<c:otherwise>
											<a style="color:red"
											   onclick="util.pay('${fns:escapeHtml(groomerRegister.id)}','groomer_register@nurse_exam',1,'${fns:escapeHtml(groomerRegister.fee) }','${fns:escapeHtml(groomerRegister.memberCode)}')">
													${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}
											</a>
										</c:otherwise>
									</c:choose>
								</c:if>
							</c:when>
							<c:when test="${groomerRegister.paymentState=='2'}">
								<font color="green">${fns:getDictLabel(groomerRegister.paymentState, 'user_payment_state', '')}</font>
							</c:when>
						</c:choose>
					</c:if>
				</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerRegister:audit">
				<td>
					<c:choose>
						<c:when test="${groomerRegister.groomerShow.showType=='cathedra'}">
							无
						</c:when>
						<c:when test="${groomerRegister.businessRefundState}">
						 ${fns:getDictLabel(groomerRegister.reviewState, 'review_state', '')}
						</c:when>
						<c:when test="${groomerRegister.groomerShow.showType=='exam' && groomerRegister.reviewState=='0' && empty groomerRegister.member.avatar}">
							<a href="#" onclick="openLayer2('${fns:escapeHtml(groomerRegister.id)}')">上传</a>
						</c:when>
							<c:when test="${groomerRegister.groomerShow.showType=='match' && groomerRegister.reviewState=='0' && empty groomerRegister.member.avatar}">
							<a href="#" onclick="openLayer2('${fns:escapeHtml(groomerRegister.id)}')">上传</a>
						</c:when>
						<c:when test="${groomerRegister.groomerShow.showType=='team' && groomerRegister.reviewState=='0' && empty groomerRegister.member.avatar}">
							<a href="#" onclick="openLayer2('${fns:escapeHtml(groomerRegister.id)}')">上传</a>
						</c:when>
						<c:when test="${groomerRegister.groomerShow.showType=='team' && groomerRegister.reviewState=='0' && groomerRegister.paymentState=='2'&& not empty groomerRegister.member.avatar}">
							<a href="#" onclick="openLayer('${fns:escapeHtml(groomerRegister.id)}')">待审核</a>
						</c:when>
						<c:when test="${groomerRegister.groomerShow.showType=='exam' && groomerRegister.reviewState=='0' && groomerRegister.paymentState=='2'&& not empty groomerRegister.member.avatar}">
							<a href="#" onclick="openLayer('${fns:escapeHtml(groomerRegister.id)}')">待审核</a>
						</c:when>
						<c:when test="${groomerRegister.groomerShow.showType=='match' && groomerRegister.reviewState=='0' && groomerRegister.paymentState=='2'&& not empty groomerRegister.member.avatar}">
							<a href="#" onclick="openLayer('${fns:escapeHtml(groomerRegister.id)}')">待审核</a>
						</c:when>
						<c:when test="${groomerRegister.reviewState=='1' }">
							<font color="green">${fns:getDictLabel(groomerRegister.reviewState, 'review_state', '')}</font>
						</c:when>
						<c:when test="${groomerRegister.reviewState=='2' }">
							<a style="color:red" title="${fns:escapeHtml(groomerRegister.reviewRemarks)}">
							${fns:getDictLabel(groomerRegister.reviewState, 'review_state', '')}</a>
						</c:when>
						
					</c:choose>
				</td>
				</shiro:hasPermission>
				<td>
				<shiro:hasPermission name="groomer:groomerRegister:view">
					<a href="${ctx}/groomer/groomerRegister/view?id=${fns:escapeHtml(groomerRegister.id)}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerRegister:edit">
				<c:if test="${!groomerRegister.businessRefundState}">
					<c:if test="${groomerRegister.groomerShow.showType!='team' }">
    					<a href="${ctx}/groomer/groomerRegister/form?id=${fns:escapeHtml(groomerRegister.id)}">编辑</a>
					</c:if>
					<c:if test="${groomerRegister.groomerShow.showType=='team' }">
						<a href="${ctx}/groomer/groomerRegister/ttform?id=${fns:escapeHtml(groomerRegister.id)}">编辑</a>
					</c:if>
				</c:if>
				</shiro:hasPermission>
   				<shiro:hasPermission name="groomer:groomerRegister:delete">
   					<c:if test="${groomerRegister.paymentState=='1' && !groomerRegister.businessRefundState}">
					<a href="${ctx}/groomer/groomerRegister/delete?id=${fns:escapeHtml(groomerRegister.id)}" onclick="return confirmx('确认要删除该记录吗？', this.href)">删除</a>
   					</c:if>
   				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>