<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员俱乐部管理</title>
	<meta name="decorator" content="default"/>
	
	<style type="text/css">
		body {
			min-height:300px;
		}
	</style>
	<script type="text/javascript">
	function modifyClub(){
		var ckuClub = $.trim($("#ckuClub option:selected").val());
		if(ckuClub == null || ckuClub == ""){
 			top.layer.msg("请选择新俱乐部后重试！");
 			return false;
 		}
		if("${member.ckuClub}" != null && "${member.ckuClub}" != "null" && "${member.ckuClub}" == ckuClub){
			$.jBox.confirm("俱乐部信息未修改，确认要保存吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					confirmModifyClub(ckuClub);
				}
			},{buttonsFocus:1});
 			return false;
		}else{
			confirmModifyClub(ckuClub);	
		}
		return false;
	}
	
	function confirmModifyClub(ckuClub){
		$.jBox.confirm("确认要修改会员所属俱乐部吗？","系统提示",function(v,h,f){
			if(v=="ok"){
				var params = {"id":"${member.id}"};
		 		params.ckuClub = ckuClub;
		 		if($("input[name='registrantModifyFlag']:checked").val() == "1"){
		 			params.registrantModifyFlag = "1";
		 		}else{
		 			params.registrantModifyFlag = "0";
		 		}
				$.ajax({
				  type:"post",
				  url:"${ctx}/groomer/groomerMember/modifyClub",
				  data:params,
				  dataType:"json",
				  success:function(data){
					  if(data.rc == 0){
						  top.layer.msg("会员所属俱乐部修改成功！");
							//1.5秒之后刷新页面
						   setTimeout(function(){
								if(parent.document.getElementById("mainFrame").contentWindow.modifyCkuClubCallback != undefined){
									parent.document.getElementById("mainFrame").contentWindow.modifyCkuClubCallback(data);
								}
								var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
								parent.layer.close(index);
						   },1500);
					  }
					  else{
						  top.layer.msg(data.msg);	  
					  }
				  }
				});
			}
		},{buttonsFocus:1});
		return false;
	}
	
	function cancel(){
		var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
		parent.layer.close(index);
	}
	
</script>
</head>
<body>
	<div id="bindForm" style="padding-top:20px;">
		<form id="inputForm" action="#" method="post" class="form-horizontal">
			<input type="hidden" id="id" name="id" value="${member.id}"/>
			<div class="control-group">
				<label class="control-label">会员编号：</label>
				<div class="controls">
					<input type="text" class="input-xlarge" value="${member.memberCode}" readonly="readonly"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">会员姓名：</label>
				<div class="controls">
					<input type="text" class="input-xlarge " value="${member.name}" readonly="readonly"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">原所属俱乐部：</label>
				<div class="controls">
					<input type="text" class="input-xlarge " value="${member.ckuClub}" readonly="readonly"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">新所属俱乐部：</label>
				<div class="controls">
					<select id="ckuClub" name="ckuClub" class="input-xlarge" style="width:284px;">
						<option value="">请选择</option>
						<c:forEach items="${groomerSchoolList}" var="school">
							<option value="${school.schoolNameCn}" ${member.ckuClub eq school.schoolNameCn ? "selected":""}>${school.schoolNameCn}</option>
						</c:forEach>
					</select>
					<div style="display: inline-block;">
						<input type="checkbox" id="registrantModifyFlag" name="registrantModifyFlag" value="1" />
						<div style="display: inline-block;vertical-align: text-top;">同时修改登记人</div>
					</div>
				</div>
			</div>
			<div class="control-group" style="text-align:center;margin-top: 10px;">
				<div class="help-inline"><font color="red">新所属俱乐部选项未根据缴费状态过滤，请自行确认美容学校缴费状态，根据实际业务员需要修改！</font> </div><br>
			</div>
			<center>
				<button class="btn btn-primary" style="width:100px;" onclick="modifyClub();return false;">确定</button> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<button class="btn btn-default" style="width:100px;" onclick="cancel();return false;">取消</button>
			</center>
		</form>
	</div>
</body>
</html>