<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师会员信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();

			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"成绩导入", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
		function loadFun(btnId){
			layer.load();
			$("#"+btnId).prop("disabled",true);
		}
		
		function closeLoadFun(btnId){
			layer.closeAll('loading');
			$("#"+btnId).prop("disabled",false);
		}
		
		function modifyCkuClubCallback(data){
			loadFun("btnSubmit");
			window.location.reload();
		}
		
		function modifyCkuClub(memberId){
			parent.layer.open({
				type: 2,
				title: ['俱乐部修改', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['650px', '400px'],
				content: "${ctx}/groomer/groomerMember/modifyClubView?id="+memberId,
			});
			return false;
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerMember/">美容师会员信息管理</a></li>
	</ul>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/groomer/groomerMember/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
	<form:form id="searchForm" modelAttribute="member" action="${ctx}/groomer/groomerMember/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>姓名/会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>是否有效：</label>
				<form:select path="paymentState" class="input-small">
					<form:option label="全部" value="3"></form:option>
					<form:options items="${fns:getDictList('valid_flag')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li>
				<label>无效阶段：</label>
				<form:select path="groomerType" class="input-small">
					<form:option label="全部" value=""></form:option>
					<form:options items="${fns:getDictList('stage_flag')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
				<shiro:hasPermission name="groomer:grade:import">
					<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>
				</shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>姓名</th>
				<th>移动电话</th>
				<th>会员类别</th>
				<th>截止日期</th>
				<th>是否有效</th>
				<th>无效阶段</th>
				<th>俱乐部</th>
				<th>登记人</th>
				<th>美容备注</th>
				<th>操作</th>
				<th>打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
				<a href="${ctx}/sys/user/member/toMemberView?memberCode=${member.memberCode}">
					${fns:escapeHtml(member.memberCode) }
				</a>
				</td>
				<td>
					${fns:escapeHtml(member.name)}
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:getDictLabels(member.groomerType, 'user_groomer_type', '')}
				</td>
				<td>
					<fmt:formatDate value="${member.groomerEndDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:choose>
						<c:when test="${member.groomerEndDate > date }">
							有效
						</c:when>
						<c:otherwise>
							<font color="red">无效</font>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<c:choose>
						<c:when test="${member.groomerEndDate < date &&member.groomerType=='reserve' }">
							预备
						</c:when>
						<c:when test="${member.groomerType=='formal' && member.groomerEndDate < date}">
							预备转正式
						</c:when>
					</c:choose>
				</td>
				<td>
					${fns:escapeHtml(member.ckuClub)}
				</td>
				<td>
					${fns:escapeHtml(member.registrant)}
				</td>
				<td>
					${fns:escapeHtml(member.groomerRemarks)}
				</td>
				<td>
					<a href="${ctx}/groomer/groomerMember/view?id=${member.id}">查看</a>
					<shiro:hasPermission name="groomer:groomerMember:edit">
    					<a href="${ctx}/groomer/groomerMember/form?id=${member.id}">编辑</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="groomer:groomerMember:modifyClub">
    					<a href="###" onclick="modifyCkuClub('${member.id}');">修改俱乐部</a>
					</shiro:hasPermission>
				</td>
				<td>
					<c:if test="${member.groomerType=='formal'&& member.printState=='0' }">
						<a href="${ctx}/groomer/groomerMember/groomerMemberPrint?id=${member.id}">打印</a>
					</c:if>
					<c:if test="${member.printState=='1' }">
						<a href="${ctx}/groomer/groomerMember/restPrint?id=${member.id}">重置打印</a>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>