<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商品管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
            //初始化界面
            let isView = '${isView}';
            if (isView == 1) {
                $('#btnSubmit').hide();
                $('#inputForm input').attr('disabled','true');
                $('#inputForm select').attr('disabled','true');
                $('#inputForm textarea').attr('disabled','true');
                $('#inputForm input').unbind();
                $('#btnCancel').removeAttr('disabled');
            }

            //回显收费项信息
            var selectItemIds = '${fns:unescapeHtml(selectItemIds)}';
            if (selectItemIds != '') {
                var selectItemList = selectItemIds.split(",");
                $.each(selectItemList, function (i, val) {
                    $("#itemIds").find("option[value='" + val + "']").attr("selected", true);
                });
                $("#itemIds").trigger("change");
            }
            //初始化表单
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});

        function changeItems() {
            let totalPrice = 0;
            $("#itemIds").find(":checked").each(function(idx,itm){
                totalPrice += parseFloat($(itm).attr('price'));
            });
            $("#price").val(totalPrice)
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/goods/sku/">商品列表</a></li>
		<li class="active">
			<c:choose>
				<c:when test="${not empty sku.id and isView == 1}">
					<a href="${ctx}/goods/sku/viewForm?id=${sku.id}">商品查看</a>
				</c:when>
				<c:when test="${not empty sku.id and isView == 0}">
					<a href="${ctx}/goods/sku/editForm?id=${sku.id}">商品编辑</a>
				</c:when>
				<c:otherwise>
					<a href="${ctx}/goods/sku/editForm">商品添加</a>
				</c:otherwise>
			</c:choose>
		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="sku" action="${ctx}/goods/sku/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">归属业务：</label>
			<div class="controls">
				<form:select id="businessId" path="businessId" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${businessServiceList}" itemLabel="businessName" itemValue="id" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">商品名称：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="32" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">金额：</label>
			<div class="controls">
				<form:input path="price" htmlEscape="false" class="input-xlarge required number" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<br>
				<span class="help-inline"><font color="red">金额根据收费项自动自己，不可手动修改</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">销售标记：</label>
			<div class="controls">
				<shiro:hasPermission name="goods:sku:sale">
					<form:select path="saleFlag" class="input-xlarge required">
						<form:option value="" label=""/>
						<form:options items="${fns:getDictList('on_off_sale')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
					</form:select>
				</shiro:hasPermission>
				<shiro:lacksPermission name="goods:sku:sale">
					<form:select path="saleFlag" class="input-xlarge required" disabled="true">
						<form:option value="" label=""/>
						<form:options items="${fns:getDictList('on_off_sale')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
					</form:select>
				</shiro:lacksPermission>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">退款标记：</label>
			<div class="controls">
				<form:select path="refundFlag" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">收费项目：</label>
			<div class="controls">
				<form:select path="itemIds" class="input-xlarge required" multiple="true" onchange="changeItems();">
					<c:forEach   items="${itemList}" var="item">
						<option value="${item.id}" price="${item.price}">
							${item.name}
						</option>
					</c:forEach>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<shiro:hasPermission name="goods:sku:registerService">
			<div class="control-group">
				<label class="control-label">处理类：</label>
				<div class="controls">
					<form:input path="serviceName" htmlEscape="false" maxlength="50" class="input-xlarge "/>
					<br>
					<span class="help-inline"><font color="red">仅限技术人员修改</font> </span>
				</div>
			</div>
		</shiro:hasPermission>
		<div class="control-group">
			<label class="control-label">排序：</label>
			<div class="controls">
				<form:input path="sort" htmlEscape="false" class="input-xlarge digits"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="goods:sku:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>