<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单项目管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.jbox-body .jbox-icon{
			top:50px!important;
		}
		body {
			min-height:300px;
		}
	</style>
	 <script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
	
		jQuery.validator.addMethod("min", function(value, element, param) {
			return this.optional(element) || parseFloat(value) >= parseFloat(param);   
		});
		
		jQuery.validator.addMethod("max", function(value, element, param) {
			return this.optional(element) || parseFloat(value) <= parseFloat(param);   
		});

		$(document).ready(function() {
			$("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
		});
		function saveRefundOrder(){
	 		$("#inputForm").ajaxSubmit({
                dataType: 'json',
                beforeSubmit: function () {
                    if (!$("#inputForm").valid() || $(".error:visible").length > 0) {
                        return false;
                    }else if($("#partRefundFlag").val() == 'true'){
        				var partRefundPrice = $("#partRefundPrice").val();
        				if(partRefundPrice == undefined || partRefundPrice == null || partRefundPrice == ""){
        					$.jBox.error("请输入退款金额！","系统提示");
        					return false;
        				}else if(parseInt(partRefundPrice) <= 0){
        					$.jBox.error("退款金额错误，请重新输入！","系统提示");
        					return false;
        				}else if(parseInt(partRefundPrice) >= parseInt('${paymentOrderRefund.totalPrice}')){
        					$.jBox.error("退款金额应小于订单金额，请重新输入！","系统提示");
        					return false;
        				}
        			} else {
        				loadFun("editBtn");
                        return true;
                    }
                },
                success: function (data) {
                	if(data.rc == 0){
  					  	top.layer.msg("修改退费记录成功！");
						//1.5秒之后刷新页面
						setTimeout(function(){
							closeLoadFun("editBtn");
							if(parent.document.getElementById("mainFrame").contentWindow.editOrderRefundCallback != undefined){
								parent.document.getElementById("mainFrame").contentWindow.editOrderRefundCallback(data);
							}
							var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
							parent.layer.close(index);
					   },1500);
				  	}
					else{
						top.layer.msg(data.msg);	  
					}
                	
                },
                error: function (err) {
                	closeLoadFun("editBtn");
                    top.layer.msg("操作失败!");
                }
            });
			return false;
		}
		
		function partRefundChange(obj){
			if($(obj).val() == 'true'){
				$("#partRefundPrice").prop("readonly",false);
				$("#partRefundPriceReq").show();
			}else{
				$("#partRefundPrice").prop("readonly",true);
				$("#partRefundPriceReq").hide();
				$("#partRefundPrice").val($("#totalPrice").val());
			}
			$("#partRefundFlag").val($(obj).val());
		}
		
		function chargingItemChange(obj){
			$("#chargingItemName").val($.trim($(obj).find("option:selected").html()));
		}
		
		function loadFun(btnId){
			layer.load();
			$("#"+btnId).prop("disabled",true);
		}
		
		function closeLoadFun(btnId){
			layer.closeAll('loading');
			$("#"+btnId).prop("disabled",false);
		}
		
		function cancel(){
			var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
			parent.layer.close(index);
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs"></ul><br/>
	<form:form id="inputForm" modelAttribute="paymentOrderRefund" action="${ctx}/finance/paymentOrderRefund/edit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<div class="control-group">
			<label class="control-label">订单编号：</label>
			<div class="controls">
				<form:input path="orderCode" class="input-xlarge" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员名称：</label>
			<div class="controls">
				<form:hidden path="memberCode" class="input-xlarge" />
				<form:hidden path="memberName" class="input-xlarge" />
				<input name="memberCodeName" value="${paymentOrderRefund.memberName}${empty paymentOrderRefund.memberCode? '' :'（ '.concat(paymentOrderRefund.memberCode.concat(' ）'))}" class="input-xlarge" type="text" readonly="true">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">订单金额：</label>
			<div class="controls">
				<form:input path="totalPrice" class="input-xlarge" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">部分退费：</label>
			<div class="controls">
				<form:select path="partRefundFlag" class="input-xlarge required" style="width: 284px;" onchange="partRefundChange(this);">
					<form:option value="false">否</form:option>
					<form:option value="true">是</form:option>
				</form:select>
	            <span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">部分退费金额：</label>
			<div class="controls">
				<form:input path="partRefundPrice" placeholder="退款金额应小于订单金额" class="input-xlarge required" type="number" min="1" max="${paymentOrderRefund.totalPrice}" readonly="${!paymentOrderRefund.partRefundFlag}" />
				<span id="partRefundPriceReq" class="help-inline" style="display: none;"><font color="red">*&nbsp;&nbsp;</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费项目：</label>
			<div class="controls">
				<form:hidden path="chargingItemName" class="input-medium"/>
				<form:select path="chargingItemId" class="input-xlarge required" style="width: 284px;" onchange="chargingItemChange(this);">
					<form:option value="">请选择</form:option>
					<c:forEach items="${itemList}" var="item">
						<form:option value="${item.id}">${item.name}</form:option>
					</c:forEach>
				</form:select>
	            <span id="paymentItemIdReq" style="display: none;" class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="refundRemark" placeholder="请输入备注信息" rows="2" maxlength="200" class="input-xlarge"/>
			</div>
		</div>
		<center>
			 <button class="btn btn-default" style="width:100px;" onclick="cancel();return false;">取消</button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<button id="editBtn" class="btn btn-primary" style="width:100px;" onclick="saveRefundOrder();return false;">保存</button>
		</center>
	</form:form>
</body>
</html>