<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>资金挂账管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/finance/paymentOnAccount/">资金挂账明细</a></li>
		<shiro:hasPermission name="finance:paymentOnAccount:add"><li><a href="${ctx}/finance/paymentOnAccount/form">资金挂账录入</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="paymentOnAccount" action="${ctx}/finance/paymentOnAccount/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>资金账号：</label>
				<form:input path="cardNo" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>金额：</label>
				<form:input path="money" htmlEscape="false" class="input-medium"/>
			</li>
			<li><label>支付方式：</label>
				<form:select path="paymentWay" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('payment_way')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li><label>起始时间：</label>
				<input name="startAddTime" id="startAddTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${paymentOnAccount.startAddTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label>结束时间：</label>
				<input name="endAddTime" id="endAddTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${paymentOnAccount.endAddTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label>备注信息：</label>
				<form:input path="remarks" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>名称</th>
				<th>资金账号</th>
				<th>挂账金额</th>
				<th>转入金额</th>
				<th>支付方式</th>
				<th>缴费时间</th>
				<th>操作人</th>
				<th>备注</th>
				<shiro:hasPermission name="finance:paymentOnAccount:changeAccount"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentOnAccount">
			<tr>

				<td>
					${fns:escapeHtml(paymentOnAccount.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(paymentOnAccount.name)}
				</td>
				<td>
					${fns:escapeHtml(paymentOnAccount.cardNo)}
				</td>
				<td>
					${fns:escapeHtml(paymentOnAccount.money)}
				</td>
				<td>
					${fns:escapeHtml(paymentOnAccount.money-paymentOnAccount.balance)}
				</td>
				<td>
					${fns:getDictLabel(paymentOnAccount.paymentWay, 'payment_way', '')}
				</td>
				<td>
					<fmt:formatDate value="${paymentOnAccount.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(paymentOnAccount.user.name)}
				</td>
				<td>
					${fns:escapeHtml(paymentOnAccount.remarks)}
				</td>
				<shiro:hasPermission name="finance:paymentOnAccount:changeAccount"><td>
					<c:if test="${paymentOnAccount.isChange=='1'}">
						<p>已转入</p>
					</c:if>
					<c:if test="${paymentOnAccount.isChange=='0'}">
						<a href="${ctx}/finance/paymentOnAccount/toChange?id=${paymentOnAccount.id}">资金转入</a>
<%--
						<a href="${ctx}/finance/paymentOnAccount/delete?id=${paymentOnAccount.id}" onclick="return confirmx('确认要删除该资金挂账吗？', this.href)">删除</a>
--%>
					</c:if>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>