<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>资金挂账管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/paymentOnAccount/">资金挂账明细</a></li>
		<shiro:hasPermission name="finance:paymentOnAccount:changeAccount"><li class="active"><a href="${ctx}/finance/paymentOnAccount/toChange?id=${paymentOnAccount.id}">资金挂账转入</a></li></shiro:hasPermission>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="paymentOnAccount" action="${ctx}/finance/paymentOnAccount/changeAccount" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<input name="memberCode" id="memberCode" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control" required title="会员号不能为空！"/>
                <span class="input-group-btn">
                <button class="btn btn-default" type="button" id="memberCodeBtnp" onclick="searchUser('p')">查</button>
                <font id="paymentState" ></font>
                </span>
			</div>
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				<input id="name" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control"/>
			</div>
			<label class="control-label">会员余额：</label>
			<div class="controls">
				<input id="accountBalance" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">转入金额：</label>
			<div class="controls">
				<input name="money" type="number" htmlEscape="false" class="form-control" required title="转入金额不能为空！"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">转入时间：</label>
			<div class="controls">
				<input name="addTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					   value="<fmt:formatDate value="${paymentOnAccount.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" required title="转入时间不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="proccessRemarks" htmlEscape="false" rows="4" maxlength="100" class="input-xxlarge"/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="finance:paymentOnAccount:changeAccount"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>
		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}

		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#name").val(json.name);
			$("#memberCode").val(json.memberCode);
			$("#accountBalance").val(json.accountBalance);
			if(json.paymentState==0){
				$("#paymentState").text('无效');
			}else if(json.paymentState==1){
				$("#paymentState").text('有效');
				$("#paymentState").css("color","red");
			};

		}
	</script>
</body>
</html>