<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>收费项目管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/finance/paymentChargingItem/">收费项目列表</a></li>
		<shiro:hasPermission name="finance:paymentChargingItem:add"><li><a href="${ctx}/finance/paymentChargingItem/form">收费项目添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="paymentChargingItem" action="${ctx}/finance/paymentChargingItem/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>收费项目名：</label>
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>部门：</label>
				<sys:treeselect id="office" name="office.id" value="${fns:escapeHtml(paymentChargingItem.office.id)}" labelName="office.name" labelValue="${fns:escapeHtml(paymentChargingItem.office.name)}"
								title="部门" url="/sys/office/treeData?type=2" cssClass="required" notAllowSelectParent="true"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>收费项目名</th>
				<th>金额</th>
				<th>部门</th>
				<th>排序字段</th>
				<th>会员可见度</th>
				<shiro:hasPermission name="finance:paymentChargingItem:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentChargingItem">
			<tr>
				<td><a href="${ctx}/finance/paymentChargingItem/view?id=${fns:escapeHtml(paymentChargingItem.id)}">
					${fns:escapeHtml(paymentChargingItem.name)}
				</a></td>
				<td>
					${fns:escapeHtml(paymentChargingItem.price)}
				</td>
				<td>
					${fns:escapeHtml(paymentChargingItem.office.name)}
				</td>
				<td>
					${fns:escapeHtml(paymentChargingItem.sort)}
				</td>
				<td>
					${fns:getDictLabel(fns:escapeHtml(paymentChargingItem.visibility), 'charging_item_visibility', '')}
				</td>
				<td>
					<shiro:hasPermission name="finance:paymentChargingItem:edit">
    					<a href="${ctx}/finance/paymentChargingItem/form?id=${fns:escapeHtml(paymentChargingItem.id)}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="finance:paymentChargingItem:delete">
						<a href="${ctx}/finance/paymentChargingItem/delete?id=${fns:escapeHtml(paymentChargingItem.id)}" onclick="return confirmx('确认要删除该收费项目吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>