<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>等级贴纸申请管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/dog/dogStickerApply/">等级贴纸申请列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="dogStickerApply" action="${ctx}/dog/dogStickerApply/"
           method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>芯片号：</label>
            <form:input path="identificationFlagLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>证书号：</label>
            <form:input path="pedigreeCertifiedLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>宠爱护照编号：</label>
            <form:input path="cabPassportLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>申请人：</label>
            <form:input path="paymentMemberNameLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>会员号：</label>
            <form:input path="paymentMemberCodeLike" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>种类：</label>
            <form:input path="dogBreed" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>性别：</label>
            <form:select path="dogGender" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>申请等级：</label>
            <form:select path="applyClassLike" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('sticker_class')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>申请时间：</label>
            <input name="createDateStart" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogStickerApply.createDateStart}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
            <input name="createDateEnd" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogStickerApply.createDateEnd}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
        </li>
        <li><label>业务状态：</label>
            <form:select path="stickerStates" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('sticker_states')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>需寄回旧版护照：</label>
            <form:select path="needReturnOldPassport" class="input-medium">
                <form:option value="" label="全部"/>
                <form:option value="1" label="是"/>
                <form:option value="0" label="否"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <sh>
        <th>芯片号码</th>
        <th>血统证书号</th>
        <th>申请人</th>
        <th>性别</th>
        <th>英文姓名</th>
        <th>种类</th>
        <th>宠爱护照号</th>
        <th>已获等级</th>
        <th>申请等级</th>
        <th>申请日期</th>
        <th>需寄回旧版护照</th>
        <th>是否需要新护照</th>
        <%--<shiro:hasPermission name="dog:dogBirthCertificate:print">--%>
        <th>类型</th>
        <th>登记卡打印</th>
        <th>等级打印</th>


        <%--</shiro:hasPermission>--%>
        <th>业务状态</th>
        </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogStickerApply">
        <tr>
            <td>
                    ${dogStickerApply.identificationFlag}
            </td>
            <td>
                    ${dogStickerApply.pedigreeCertified}
            </td>
            <td>
                    ${dogStickerApply.paymentMemberName}
            </td>
            <td>
                    ${fns:getDictLabel(dogStickerApply.dogGender, 'dog_gender', '')}
            </td>
            <td>
                    ${dogStickerApply.nameEn}
            </td>
            <td>
                    ${dogStickerApply.dogBreed}
            </td>
            <td>
                    ${dogStickerApply.cabPassport}
            </td>
            <td>
                    ${dogStickerApply.alreadyHaveClass}
            </td>
            <td>
                    ${dogStickerApply.applyClass}
            </td>
            <td>
                <fmt:formatDate value="${dogStickerApply.createDate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                <c:if test="${dogStickerApply.needReturnOldPassport == '1'}">
                    <font color="red">是</font>
                </c:if>
                <c:if test="${dogStickerApply.needReturnOldPassport == '0'}">否</c:if>
            </td>
            <td>
                <c:if test="${dogStickerApply.needNewPassport == '1'}">
                    <font color="red">是</font>
                </c:if>
                <c:if test="${dogStickerApply.needNewPassport == '0'}">否</c:if>
            </td>
            <td>
                 <c:if test="${dogStickerApply.ecertFlag == '1'}">电子</c:if>
                 <c:if test="${dogStickerApply.ecertFlag != '1' }">实体</c:if>
            </td>
            
            
            
            <%--<shiro:hasPermission name="dog:dogBirthCertificate:print">--%>
                <td>
                    <%--<c:if test="${dogStickerApply.needNewPassport == '1'}">--%>
                        <c:if test="${dogStickerApply.paymentState==2 && dogStickerApply.registerCardPrintFlag==0 && dogStickerApply.ecertFlag != '1'}">
                            <a href="${ctx}/dog/dogStickerApply/printRegisterCard?id=${dogStickerApply.id}"
                               onclick="return confirmx('确认要打印该纯种犬身份登记卡吗？', this.href)">打印</a>
                        </c:if>
                        <c:if test="${dogStickerApply.registerCardPrintFlag==1}">
                            <a href="${ctx}/dog/dogStickerApply/resetPrintRegisterCard?id=${dogStickerApply.id}"
                               onclick="return confirmx('确认要重置打印该纯种犬身份登记卡吗？', this.href)">重置</a>
                        </c:if>
                    <%--</c:if>--%>
                </td>
                <td>
                    <fmt:parseDate value="2020-04-29 00:00:00" var="endtime"/>
                    <c:if test="${dogStickerApply.createDate < endtime}">
                        <c:if test="${dogStickerApply.paymentState==2 && dogStickerApply.stickerPrintFlag==0}">
                            <a href="${ctx}/dog/dogStickerApply/printSticker?id=${dogStickerApply.id}"
                               onclick="return confirmx('确认要打印该贴纸吗？', this.href)">打印</a>
                        </c:if>
                        <c:if test="${dogStickerApply.stickerPrintFlag==1}">
                            <a href="${ctx}/dog/dogStickerApply/resetPrintSticker?id=${dogStickerApply.id}"
                               onclick="return confirmx('确认要重置打印贴纸吗？', this.href)">重置</a>
                        </c:if>
                    </c:if>
                </td>
            <%--</shiro:hasPermission>--%>
            <td>
                    ${dogStickerApply.businessStates}
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>