<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书换发管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function auditForm(id){
 			parent.layer.open({
				type: 2,
				title: ['证书换发审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '600px'],
				content: ctx+"/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/auditForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/list?dogBreed=230">证书换发列表</a></li>
		<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:edit"><li><a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/form">证书换发添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogPedigreeCertifiedChange" action="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/" method="post" class="breadcrumb form-search">
		<input name="dogBreed" type="hidden" value="230"/>
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>血统证书编号：</label>
				<form:input path="overseasPedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedChange.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>国外血统证书编号</th>
				<th>犬种</th>
				<th>犬名</th>
				<th>犬主</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>换发配种证明</th>
				<th>流程状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogPedigreeCertifiedChange">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.overseasPedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.breedCnName)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogBreed)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogName)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedChange.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedChange.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedChange.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td style="color:${dogPedigreeCertifiedChange.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogPedigreeCertifiedChange.paymentState, 'user_payment_state', '')}
				</td>
				<td style="color:#000" title="${fns:escapeHtml(dogPedigreeCertifiedChange.reviewRemarks)}">
					<c:if test="${dogPedigreeCertifiedChange.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogPedigreeCertifiedChange.reviewState=='0'}">
							<a style="color:#F00" onclick="auditForm('${fns:escapeHtml(dogPedigreeCertifiedChange.id)}')">${fns:getDictLabel(dogPedigreeCertifiedChange.reviewState, 'review_state', '')}</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogPedigreeCertifiedChange.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				<td>
					<c:choose>
						<c:when test="${not empty dogPedigreeCertifiedChange.fmdogBreedCertifiedCode &&dogPedigreeCertifiedChange.reviewState=='1'  }">
							<a href="${ctx}/dog/dogamphimixis/dogAmphimixisProve/editForm?id=${dogPedigreeCertifiedChange.dogId}">${fns:escapeHtml(dogPedigreeCertifiedChange.fmdogBreedCertifiedCode)}</a>
						</c:when>
						<c:when test="${dogPedigreeCertifiedChange.reviewState=='1'}">
							<shiro:hasPermission name="dog:dogamphimixis:dogAmphimixisProve:add">
							<a href="${ctx}/dog/dogamphimixis/dogAmphimixisProve/form?dogBreed=${fns:escapeHtml(dogPedigreeCertifiedChange.dogBreed)}">录入</a>
							</shiro:hasPermission>
						</c:when>
					</c:choose>
				</td>
				<td>
					
					<c:choose>
						<c:when test="${dogPedigreeCertifiedChange.reviewState=='1'&&dogPedigreeCertifiedChange.processState=='0'}">
							<a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/resolve?id=${fns:escapeHtml(dogPedigreeCertifiedChange.id)}"
								onclick="return confirmx('确认要处理该证书换发吗？', this.href)">
							${fns:getDictLabel(dogPedigreeCertifiedChange.processState, 'proccess_state', '')}
							</a>
						</c:when>
						<c:when test="${dogPedigreeCertifiedChange.processState=='1'}">
							${fns:getDictLabel(dogPedigreeCertifiedChange.processState, 'proccess_state', '')}
						</c:when>
					</c:choose>
				</td>
				<td>
    				<a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/form?id=${dogPedigreeCertifiedChange.id}">查看</a>
				<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:edit">
					<a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/editForm?id=${dogPedigreeCertifiedChange.id}">编辑</a>
				</shiro:hasPermission>
				<c:if test="${dogPedigreeCertifiedChange.processState=='1'}">
				<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:print">
					<c:if test="${dogPedigreeCertifiedChange.printState=='2'}">
						<a href="###" onclick="print('${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/print?id=${dogPedigreeCertifiedChange.id}');">打印</a>
					</c:if>
				</shiro:hasPermission>
				<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:resetPrint">
					<c:if test="${dogPedigreeCertifiedChange.printState=='02'}">
						<a href="###" onclick="resetPrint('${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/resetPrint?id=${dogPedigreeCertifiedChange.id}');">重置打印</a>
					</c:if>
				</shiro:hasPermission>
				</c:if>
				<shiro:hasPermission name="dogpedigreecertifiedchange:dogPedigreeCertifiedChange:delete">
					<a href="${ctx}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/delete?id=${dogPedigreeCertifiedChange.id}" onclick="return confirmx('确认要删除该证书换发吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>