<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>配种证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					save();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
       function searchKin(){
    	   var fPedigreeCertifiedCode = $("#malePedigreeCertified").val();
           var mPedigreeCertifiedCode = $("#femalePedigreeCertified").val();
           if(fPedigreeCertifiedCode==''||fPedigreeCertifiedCode==''){
        	   alert("请填写公母犬信息！");
        	   return;
           }
           parent.layer.open({
               type: 2,
               title: ['近亲繁殖查询', 'font-size:18px;text-align: center;'],
               shadeClose: false,
               shade: [0.8, '#393D49'],
               maxmin: false, //开启最大化最小化按钮
               area: ['1000px', '600px'],
               content: ctx+"/dog/dog/kinBreedMessage?fPedigreeCertifiedCode="+fPedigreeCertifiedCode+"&mPedigreeCertifiedCode="+mPedigreeCertifiedCode,
               end: function(){
            	   
               }
           }); 
       };

       var maleDogBreed = '';
       var femaleDogBreed = '';

       function save(){
           var frm = $("#inputForm");
           if($("#maleDogId").val()==''||$("#femaleDogId").val()==''){
        	   alert("请先查询出公/母犬信息！");
        	   return false;
           }
           if(maleDogBreed=='181A'||maleDogBreed=='181B'||maleDogBreed=='181C'){
        	   maleDogBreed = "181";
           }
           if(maleDogBreed=='182A'||maleDogBreed=='182B'){
               maleDogBreed = "182";
           }
           if(maleDogBreed=='183A'||maleDogBreed=='183B'||maleDogBreed=='183C'||maleDogBreed=='183D'){
               maleDogBreed = "183";
           }
           if(femaleDogBreed=='181A'||femaleDogBreed=='181B'||femaleDogBreed=='181C'){
        	   femaleDogBreed = "181";
           }
           if(femaleDogBreed=='182A'||femaleDogBreed=='182B'){
        	   femaleDogBreed = "182";
           }
           if(femaleDogBreed=='183A'||femaleDogBreed=='183B'||femaleDogBreed=='183C'||femaleDogBreed=='183D'){
        	   femaleDogBreed = "183";
           }
           if(femaleDogBreed.indexOf("148") >= 0){
        	   femaleDogBreed = "148";
           }
           if(maleDogBreed.indexOf("148") >= 0){
               maleDogBreed = "148";
           }
           if(femaleDogBreed.indexOf("172") >= 0){
        	   femaleDogBreed = "172";
           }
           if(maleDogBreed.indexOf("172") >= 0){
               maleDogBreed = "172";
           }
           if(maleDogBreed!=femaleDogBreed){
        	   alert("公母犬犬种应一致！");
        	   return false;
           }
           loading('正在提交，请稍等...');
           var dataPara = util.getFormJson(frm);
           $.ajax({
               url: '${ctx}/dognewborn/dogNewborn/orderSave',
               type: 'POST',
               async: false, 
               data: dataPara,
               success: function(json){
            	   if(json=='ok'){
                       parent.isYes = true;
                       parent.layer.closeAll();
            	   }else{
            		   alert(json);
            	   }
               }
           });
       }
       function closeLayer(){
           parent.isYes = false;
           parent.layer.closeAll();
       }
       function breedNumber(){
    	   var femalePedigreeCertified = $("#femalePedigreeCertified").val();
    	   if(femalePedigreeCertified==''){
    		   alert("请填写母犬血统证书号！");
    		   return;
    	   }
    	   $.ajax({
               type:"POST",
               url:"${ctx}/dognewborn/dogNewborn/getBreedNumber",
               data:{
            	   femalePedigreeCertified:femalePedigreeCertified
               },
               async: false, 
               success: function(data){
                   var str = eval(data);
                   var date = new Date();
                   var count = 0;
                   var birthday = "";
                   $("#tbody").html('');
                   $("#table").show();
                   $("#count").show();
                   $("#close").show();
                   $.each(str,function(){
                	   count++;
                	   if(this.birthday!=null&&this.birthday!=''){
                           birthday = util.formatDateShort(this.birthday.time);
                       }else{
                           birthday = "";
                       }
                	   $("#tbody").append(
                	   "<tr>"+
                	   "<td>"+this.breedCertifiedCode+"</td>"+
                	   "<td>"+this.area+"</td>"+
                	   "<td>"+this.maleDogOwner+"</td>"+
                	   "<td>"+this.malePedigreeCertified+"</td>"+
                	   "<td>"+this.femaleDogOwner+"</td>"+
                	   "<td>"+this.femalePedigreeCertified+"</td>"+
                	   "<td>"+util.formatDateShort(this.breedDate.time)+"</td>"+
                	   "<td>"+birthday+"</td>"+
                	   "<td>"+this.puppyBirthNum+"</td>"+
                	   "<td>"+this.reviewState+"</td>"+
                	   "</tr>"
                	   )
                   });
                   $("#count").text("繁殖次数总计："+count);
               }
          });
       }
       function closeTable(){
    	   $("#table").hide();
    	   $("#close").hide();
       }
       //公犬信息查询
       function getDogBymalePedigreeCertified(){
    	   var malePedigreeCertified = $("#malePedigreeCertified").val();
           if(malePedigreeCertified==''){
               alert("请填写血统证书号！");
               return;
           }
           $.post('${ctx}/dognewborn/dogNewborn/getDogByPedigreeCertified', {
               pedigreeCertified: malePedigreeCertified
           }, function(data) {
            maleDogBreed = '';
            $("#maleDogId").val('');
        	   if(data.gender=='公'){
        		   //非CKU开头犬只有可能犬主会员号为空，所以只校验CKU开头的犬只
        		   if(malePedigreeCertified.toUpperCase().substring(0,3) == 'CKU'){
	        		   if($("#memberCode").val()!=data.dogOwnerMemberCode){
	        			   alert("公犬主需与缴费会员为同一人！");
	        			   $("#malePedigreeCertified").val('');
	        			   return;
	        		   }
	        		   if(data.memberType!='professional'){
	        			   alert("公犬主非专业会员！");
	        			   $("#malePedigreeCertified").val('');
	        			   return;
	        		   }
        		   }
        		   if(data.dogState=='0'){
        			   $("#maleDogId").val(data.dogId);
                       $('#maleDogOwner').val(data.dogOwner);
                       $('#mdogOwnerCode').val(data.dogOwnerMemberCode);
                       $("#maleDogName").val(data.nameEn);
                       $("#maleDogGender").val(data.gender);
                       maleDogBreed = data.dogBreed;
        		   } else {
        			   alert("犬只状态不正常！");
        			   $("#malePedigreeCertified").val('');
        		   }
        	   } else {
        		   alert("犬只性别不正确！");
        		   $("#malePedigreeCertified").val('');
        	   }
           });
       }
       //母犬信息查询
       function getDogByfemalePedigreeCertified(){
           var femalePedigreeCertified = $("#femalePedigreeCertified").val();
           if(femalePedigreeCertified==''){
               alert("请填写血统证书号！");
               return;
           }
           $.post('${ctx}/dognewborn/dogNewborn/getDogByPedigreeCertified', {
               pedigreeCertified: femalePedigreeCertified
           }, function(data) {
            femaleDogBreed = '';
            $("#femaleDogId").val('');
        	   if(data.gender=='母'){
        		   if(data.dogState=='0'){
        			   $("#femaleDogId").val(data.dogId);
                       $('#femaleDogOwner').val(data.dogOwner);
                       $('#fdogOwnerCode').val(data.dogOwnerMemberCode);
                       $("#femaleDogName").val(data.nameEn);
                       $("#femaleDogGender").val(data.gender);
                       femaleDogBreed = data.dogBreed;
        		   } else {
        			   alert("犬只状态不正常！");
                       $("#femalePedigreeCertified").val('')
        		   }
        	   } else {
        		   alert("犬只性别不正确！");
        		   $("#femalePedigreeCertified").val('')
        	   }
           });
       }
	</script>
</head>

<body>
	<form:form id="inputForm" modelAttribute="dogNewborn" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<input name="paymentChargingItemId" value="${chargingItemId}" type="hidden" >
		<form:hidden path="runningNumber"/>
		<input id="maleDogId" type="hidden" >
		<input id="femaleDogId" type="hidden" >
		<input id="femaleDogId" type="hidden" id="chargingItemId" name="chargingItemId" value="${chargingItemId}">
		<input id="maleDogGender" type="hidden" >
		<input id="maleDogBreed" type="hidden" >
		<input id="femaleDogGender" type="hidden" >
		<input id="femaleDogBreed" type="hidden" >
		<input id="memberCode" type="hidden" name="memberCode" value="${memberCode}">
		<div class="control-group" >
			<label class="control-label" >公犬主人姓名：</label>
			<div class="controls">
				<form:input path="maleDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">公犬主人会员号：</label>
			<div class="controls">
				<form:input path="mdogOwnerCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">母犬主人姓名：</label>
			<div class="controls">
				<form:input path="femaleDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬主人会员号：</label>
			<div class="controls">
				<form:input path="fdogOwnerCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">公犬姓名：</label>
			<div class="controls">
				<form:input path="maleDogName" htmlEscape="false" maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">公犬证书号：</label>
			<div class="controls">
				<form:input path="malePedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<input id="" class="btn btn-primary" type="button" value="查" onclick="getDogBymalePedigreeCertified()"/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">母犬姓名：</label>
			<div class="controls">
				<form:input path="femaleDogName" htmlEscape="false" maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬证书号：</label>
			<div class="controls">
				<form:input path="femalePedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<input id="" class="btn btn-primary" type="button" value="查" onclick="getDogByfemalePedigreeCertified()"/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label">配种日期：</label>
			<div class="controls">
				<input name="breedDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${dogNewborn.breedDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false,maxDate:'%y-%M-%d'});"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">审核近亲：</label>
            <div class="controls">
                <input id="" class="btn btn-primary" type="button" value="审查" onclick="searchKin()"/>&nbsp;&nbsp;
                <label>近亲结果：</label>
                <form:select path="kinBreed" class="input-xlarge" style="width: 80px;" >
                    <form:option value="0" label="请选择"/>
                    <form:options items="${fns:getDictList('kinResults')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>&nbsp;&nbsp;
                <input id="" class="btn btn-primary" type="button" value="审核母犬繁殖次数" onclick="breedNumber()"/>&nbsp;&nbsp;
            </div>
        </div>
        <table id="table" class="table table-striped table-bordered table-condensed" style="display:none">
	        <thead>
	            <tr>
	                <th>配种证明编号</th>
	                <th>所属地区</th>
	                <th>公犬主</th>
	                <th>公犬证书号</th>
	                <th>母犬主</th>
	                <th>母犬证书号</th>
	                <th>配种日期</th>
	                <th>出生日期</th>
	                <th>出生数量</th>
	                <th>审核状态</th>
	            </tr>
	        </thead>
	        <tbody id="tbody">
	        </tbody>
	        <td colspan="10" style="display:none" id="count"></td>
        </table>
        <input id="close" class="btn" type="button" value="关闭" onclick="closeTable()" style="display:none"/>
		<div class="form-actions">
			<shiro:hasPermission name="dognewborn:dogNewborn:${not empty dogNewborn.id?'edit':'add'}"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>