<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>广告位管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					var bannerImg = $("#bannerImg").val();
					if(bannerImg == '' || bannerImg == null){
						$("#imgSpan").html('<font color="red">图片不能为空</font>');
						return;
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				rules:{
					bannerName:{
						required:true
					},
					bannerSort:{
						required:true,
						max: 9999999
					},
					bannerPlace:{
						required:true
					},
					kennelCode:{
						required:true
					},
					kennelName:{
						required:true
					},
					kennelManager:{
						required:true
					},
					startDate:{
						required:true
					},
					endDate:{
						required:true
					},
					kennelBreed:{
						required:true
					},
					kennelProvince:{
						required:true
					},
					kennelCity:{
						required:true
					},
					kennelArea:{
						required:true
					}
				}, 
				 messages:{
						kennelBreed:{
							required:"请在犬舍管理完善信息"
						},
						kennelArea:{
							required:"请在犬舍管理完善信息"
						},
						kennelCity:{
							required:"请在犬舍管理完善信息"
						},
						kennelProvince:{
							required:"请在犬舍管理完善信息"
						},
						kennelName:{
							required:"请在犬舍管理完善信息"
						},
						kennelManager:{
							required:"请在犬舍管理完善信息"
						},		 
					/*
					bannerName:{
						required:"广告位名称不能为空"
					},
					bannerSort:{
						required:"排序不能为空"
					},
					bannerPlace:{
						required:"广告位置不能为空"
					},
					kennelCode:{
						required:"链接数据不能为空"
					},
					kennelName:{
						required:"犬舍名称不能为空"
					},
					kennelManager:{
						required:"犬舍主理人不能为空"
					},
					startDate:{
						required:"开始时间不能为空"
					},
					endDate:{
						required:"结束时间不能为空"
					},
					kennelBreed:{
						required:"主营犬舍不能为空"
					},
					kennelProvince:{
						required:"犬舍地址不能为空"
					},
					kennelCity:{
						required:"犬舍地址不能为空"
					},
					kennelArea:{
						required:"犬舍地址不能为空"
					}*/
				}, 
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			
			$("#bannerPlace").change(function(){
				 var value = $(this).val();
				 if(value == '3'){
					 $("#imgSize").html("宽360px*高360px 图片类型支持jpg,png,大小限制在1M以内,传直角图片即可");
				 }else{
					 $("#imgSize").html("宽346px*高182px 图片类型支持jpg,png,大小限制在1M以内,传直角图片即可");
				 }
			});
			
		});
		
		function searchKennel(){
            top.layer.open({
                type: 2,
                title: ['犬舍查询', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['700px', '500px'],
                content: "${ctx}/kennel/kennel/search/page"
            });
        }
		
		  this.searchKennelCallback = function (json){
			  $("#kennelCode").val(json.kennelCode);
			  $("#kennelName").val(json.name);
			  $("#kennelManager").val(json.memberName);
			  $("#kennelBreed").val(null);
			  // 犬种信息
			  var dogBreedCode = json.mainDogBreedFirst
			  $.ajax({
					url:'${ctx}/dogtype/dogType/type/list',
					data: {},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json1){
						for(var i = 0;i<json1.length;i++){
							if(dogBreedCode==json1[i].dogBreedCode) {
								 $("#kennelBreed").val(json1[i].breedCnName);
								return;
							} 
						}
					}
			  });
			  // 地址信息
			  var province = json.province;
			  var city = json.city;
			  var area = json.area;
			  $("#kennelProvince").val(province);
			  $("#kennelCity").val(city);
			  $("#kennelArea").val(area);
			 
	       }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/banner/appBanner/">广告位列表</a></li>
		<li class="active"><a href="${ctx}/banner/appBanner/form?id=${appBanner.id}">广告位<shiro:hasPermission name="banner:appBanner:edit">${not empty appBanner.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="banner:appBanner:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="appBanner" action="${ctx}/banner/appBanner/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">广告位名称：</label>
			<div class="controls">
				<form:input path="bannerName" htmlEscape="false" maxlength="20" class="input-xlarge " placeholder = "广告位名称不超过20字"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">排序：</label>
			<div class="controls">
				<form:input path="bannerSort" type="number" htmlEscape="false"  class="input-xlarge " placeholder = "请输入序号" />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">广告位置</label>
			<div class="controls">
				 <form:select path="bannerPlace" class="input-xlarge" >
					<form:option value="">请选择</form:option>
                    <form:options items="${fns:getDictList('banner_place')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>	
                <span class="help-inline"><font color="red">*</font> </span>		
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">链接类型：</label>
			<div class="controls">
				 <form:select path="bannerType" class="input-xlarge" >
                    <form:options items="${fns:getDictList('banner_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>	
                <span class="help-inline"><font color="red">*</font> </span>	
                
                <span class="help-inline">   APP原生默认跳转到犬舍详情</span>	
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">链接数据：</label>
			<div class="controls">
				<form:input path="kennelCode" htmlEscape="false" maxlength="32" class="input-xlarge"  readonly="true"/>
				<input id="search" class="btn btn-primary" type="button" value="选择犬舍" onclick="searchKennel()"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">犬舍名称：</label>
			<div class="controls">
				<form:input path="kennelName" htmlEscape="false" maxlength="10" placeholder = "犬舍中文名不超过10个字" class="input-xlarge" 
						readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍主理人：</label>
			<div class="controls">
				<form:input path="kennelManager" htmlEscape="false" maxlength="5" placeholder = "主理人姓名不超过5个字" class="input-large" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">主营犬种：</label>
			<div class="controls">
				<form:input path="kennelBreed" htmlEscape="false" class="input-large" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:input path="kennelProvince" htmlEscape="false" class="input-large" readonly="true" style="width:122px;"/>
				市
				<form:input path="kennelCity" htmlEscape="false" class="input-large" readonly="true" style="width:122px;"/>
				区
				<form:input path="kennelArea" htmlEscape="false" class="input-large" readonly="true" style="width:122px;"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
			
		<%-- <div class="control-group">
			<label class="control-label">主营犬种描述：</label>
			<div class="controls">
				<form:input path="kennelBreedDesc" htmlEscape="false" maxlength="32" class="input-xlarge "/>
				<span class="help-inline"><font color="red">*</font> </span>	
			</div>
		</div> --%>
		
		<div class="control-group" style="width:80%">
			<label class="control-label">广告图：</label> 
			<div class="controls">
				<sys:singleImgUpload module="banner" imgId="bannerImg" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1" successCallback="uploadSuccess"/>
				<form:input path="bannerImg" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#bannerImg").val(response.id);
					}
				</script>
				图片尺寸:<span class="help-inline" id="imgSize"> 宽346px*高182px 图片类型支持jpg,png,大小限制在1M以内,传直角图片即可</span>
				<span id="imgSpan" class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		

		<div class="control-group">
			<label class="control-label">广告时间：</label>
			<div class="controls">
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					   value="<fmt:formatDate value="${appBanner.startDate}" pattern="yyyy-MM-dd"/>"
					   onFocus="var endDate=$dp.$('endDate');WdatePicker({onpicked:function(){endDate.focus();},minDate:'%y-%M-{%d}',
					dateFmt:'yyyy-MM-dd',startTime:'%y-%M-%d'})"  placeholder="开始时间 "/>
				<span class="help-inline"><font color="red">*</font> </span>
				~
				<input id="endDate"  name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
						value="<fmt:formatDate value="${appBanner.endDate}" pattern="yyyy-MM-dd"/>"
						onFocus="WdatePicker({minDate:'#F{$dp.$D(\'startDate\')}',dateFmt:'yyyy-MM-dd',startDate:'%y-%M-%d'})"  placeholder="结束时间 "/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div> 
			<div class="controls">
               	<span class="help-inline" id="imgSize">广告时间段内,状态为启用的的广告,将自动展示在前台</span> 
            </div>
			
		</div>
		
	 	<div class="control-group">
               <label class="control-label">启动状态：</label>
               <div class="controls">
                   <input type="radio" name="bannerStatus" checked="checked" value="0">启动
                   <input type="radio" name="bannerStatus" value="1">禁用
               </div>
               <div class="controls">
               	<span class="help-inline" id="imgSize">被禁用的广告不在前台展示</span> 
               </div>
        </div>
		
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks"  htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		
		<div class="form-actions">
			<shiro:hasPermission name="banner:appBanner:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>