<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>课程管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/appreciation/appreciationCourses/export");
						$("#searchForm").submit();
						$("#searchForm").attr("action","${ctx}/appreciation/appreciationCourses");
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});

		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

		function openRelCoursewarePage(id){
			parent.layer.open({
				type: 2,
				title: ['关联课程', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '558px'],
				content: ctx+"/appreciation/appreciationCourses/coursewareForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		};
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/appreciation/appreciationCourses/">课程管理列表</a></li>
		<shiro:hasPermission name="appreciation:appreciationCourses:add">
			<li><a href="${ctx}/appreciation/appreciationCourses/editForm">课程添加</a></li>
		</shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="appreciationCourses" action="${ctx}/appreciation/appreciationCourses/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>课程名称：</label>
				<form:input path="courseName" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>开始时间：</label>
				<input name="beginStartDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appreciationCourses.beginStartDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endStartDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${appreciationCourses.endStartDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>合作方：</label>
				<form:input path="coursePartner" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>课程状态：</label>
				<form:select path="states" class="input-medium">
					<form:option value="" label=""/>
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('appreciation_courses_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="appreciation:appreciationCourses:export">
			<li><input id="btnExport" class="btn btn-primary" type="button" value="导出"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>课程编号</th>
				<th>课程名称</th>
				<th>课程时间</th>
				<th>讲师</th>
				<th>合作方</th>
				<th>课程状态</th>
				<th>报名上限</th>
				<th>报名人数</th>
				<th>课程地点</th>
				<th>课程资料</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="appreciationCourses">
			<tr>
				<td>
						${appreciationCourses.courseCode}
				</td>
				<td>
						${appreciationCourses.courseName}
				</td>
				<td>
					<fmt:formatDate value="${appreciationCourses.startDate}" pattern="yyyy-MM-dd"/>
					至
					<fmt:formatDate value="${appreciationCourses.endDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
						${appreciationCourses.teacher}
				</td>
				<td>
						${appreciationCourses.coursePartner}
				</td>
				<td>
						${fns:getDictLabel(appreciationCourses.states, 'appreciation_courses_state', '')}
				</td>
				<td>
						${appreciationCourses.maxNum}
				</td>
				<td>
						${appreciationCourses.courseApplyCount}
				</td>
				<td>
						${appreciationCourses.courseLocation}
				</td>
				<td>
						${appreciationCourses.courseCourseware}
				</td>
				<td>
					<shiro:hasPermission name="appreciation:appreciationCourses:edit">
						<c:if test="${'2' != appreciationCourses.states}">
							<a href="${ctx}/appreciation/appreciationCourses/editForm?id=${appreciationCourses.id}">修改</a>
						</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="appreciation:appreciationCourses:del">
						<a href="${ctx}/appreciation/appreciationCourses/delete?id=${appreciationCourses.id}"
						   onclick="return confirmx('确认要删除该课程吗？', this.href)">删除</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="appreciation:appreciationCourses:rel">
						<a onclick="openRelCoursewarePage('${appreciationCourses.id}')">关联资料</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="appreciation:appreciationCourses:end">
						<%--未结束状态可结束--%>
						<c:if test="${'2' != appreciationCourses.states}">
							<a href="${ctx}/appreciation/appreciationCourses/end?id=${appreciationCourses.id}"
							   onclick="return confirmx('是否确认结束课程，课程结束后将自动为学员生成电子证书？', this.href)">结束课程</a>
						</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>