package com.cku.subsystem.sys;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.util.MD5Generator;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.servlet.ValidateCodeServlet;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.security.FormAuthenticationFilter;
import com.thinkgem.jeesite.modules.sys.security.UsernamePasswordToken;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 杜高业务后台管理系统
 * @author chaixueteng
 *
 */
@Controller
@RequestMapping(value="/subSystem")
public class SysLoginController {
	@Autowired
	private SystemService systemService;
	@Autowired
	private LoginServerService loginServerService;
	//账号userType类型
	private static final String DC_USER_TYPE = "5";
	private static final String MC_USER_TYPE = "7";

	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}

	//用户退出
	@RequestMapping(value="/dcoa/logout" , method=RequestMethod.GET)
	public String logout(HttpServletRequest request,HttpServletResponse response) throws IOException{
		try{
			SecurityUtils.getSubject().logout();
		}catch(Exception e){
			e.printStackTrace();
		}
		String url = request.getHeader("Referer");
		return "redirect:" + url;
	}

	@RequestMapping(value = {"/dcoa","/dcoa/index"}, method = RequestMethod.GET)
	public String loginPage(){
		return "subSystem/dcoa/sys/sysLogin";
	}

	//杜高的登录
	@RequestMapping(value = "/dcoa/login", method = RequestMethod.POST)
	public String login(@RequestParam String username,@RequestParam String password,HttpServletRequest request,Model model){
		String host = IPLimitUtil.getIpAddr((HttpServletRequest)request);
		//获取登录端 by zhuoHeng 2017年4月20日11:41:36
		String loginType = ServletUtils.getParameter(request, "loginType",null);

		try{
			User user = doLogin(username, password,null, host,loginType,DC_USER_TYPE);
			UserUtils.getSession().setAttribute("user", user);
			model.addAttribute("source","dcoa");
			return "subSystem/dcoa/sys/index";

		}catch(Exception e){
			model.addAttribute(FormAuthenticationFilter.DEFAULT_USERNAME_PARAM, username);
			model.addAttribute(FormAuthenticationFilter.DEFAULT_MESSAGE_PARAM, e.getMessage());
			return "subSystem/dcoa/sys/sysLogin";
		}
	}

	//用户刷新页面
	@RequestMapping(value = "/dcoa/login", method = RequestMethod.GET)
	public String getLogin(HttpServletRequest request,Model model){
		User user = UserUtils.getLoginUser();
		if(user == null || !SecurityUtils.getSubject().isAuthenticated()){
			return "subSystem/dcoa/sys/sysLogin";
		}
		model.addAttribute("source","dcoa");
		return "subSystem/"+getUrlByUserType()+"/sys/index";
	}

	private User doLogin(String username, String password,String validateCode,
			String host,String loginType,String userType) {
		if(StringUtils.isBlank(username)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
		}
		if(StringUtils.isBlank(password)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码不能为空");
		}
		//验证码校验
		//userService.checkValidateCode(validateCode);
		User user = systemService.getUserByLoginNameAndUserType(username,userType);
		if(user==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
		}
		if(StringUtils.isNotBlank(user.getLoginFlag())&&"0".equals(user.getLoginFlag())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号已禁止登录");
		}
		if(!user.getPassword().equals(MD5Generator.generate16(password))){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
		}
		//将用户信息存放到登录信息里
		UsernamePasswordToken token = new UsernamePasswordToken(username,password.toCharArray(),userType,false,host,validateCode,false,loginType);
		SecurityUtils.getSubject().login(token);

		return user;
	}

	/**
	 * 密码页
	 * @Author chaixueteng
	 * @2016年10月13日上午9:57:54
	 */
	@RequestMapping(value="/rePassword")
	public String rePassword(Model model){
		User user = UserUtils.getLoginUser();
		model.addAttribute("user", user);
		return "subSystem/dcoa/sys/rePassword";
	}

	/**
	 * 修改密码
	 * @Author chaixueteng
	 * @2016年10月13日上午11:10:48
	 */
	@RequestMapping(value="/updatePassword")
	public String updatePassword(String oldPassword, String newPassword, Model model){
		User user = UserUtils.getLoginUser();
		if (StringUtils.isNotBlank(oldPassword) && StringUtils.isNotBlank(newPassword)){
			if (SystemService.validatePassword(oldPassword, user.getPassword())){
				systemService.updatePasswordById(user.getId(), user.getLoginName(), newPassword);
				model.addAttribute("message", "修改密码成功");
			}else{
				model.addAttribute("message", "修改密码失败，旧密码错误");
			}
		}
		model.addAttribute("user", user);
		return "subSystem/dcoa/sys/rePassword";
	}

	/**
	 *
	 * @description: 获取验证码
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午6:27:34
	 */
	@RequestMapping(value = "/validateCode", method = RequestMethod.GET)
	public void getHospital(HttpServletRequest request,
			HttpServletResponse response) throws IOException, ServletException {
		ValidateCodeServlet servlet = new ValidateCodeServlet();
		servlet.doGet(request, response);
	}

	@ResponseBody
	@RequestMapping(value = "treeData")
	public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, HttpServletResponse response) {
		List<Map<String, Object>> mapList = Lists.newArrayList();
		extId = URLDecoder.decode(extId);
		List<Area> list = UserUtils.getCityByProvince(extId);
		for (int i=0; i<list.size(); i++){
			Area e = list.get(i);
			Map<String, Object> map = Maps.newHashMap();
			map.put("id", e.getId());
			map.put("pId", e.getParentId());
			map.put("name", e.getName());
			mapList.add(map);
		}
		return mapList;
	}


	//马犬登录

	@RequestMapping(value = {"/mcoa","/mcoa/index"}, method = RequestMethod.GET)
	public String loginPageMc(){
		return "subSystem/mcoa/sys/sysLogin";
	}

	//杜高的登录
	@RequestMapping(value = "/mcoa/login", method = RequestMethod.POST)
	public String loginMc(@RequestParam String username,@RequestParam String password,HttpServletRequest request,Model model){
		String host = IPLimitUtil.getIpAddr((HttpServletRequest)request);
		//获取登录端 by zhuoHeng 2017年4月20日11:41:36
		String loginType = ServletUtils.getParameter(request, "loginType",null);

		try{
			User user = doLogin(username, password,null, host,loginType,MC_USER_TYPE);
			UserUtils.getSession().setAttribute("user", user);
			model.addAttribute("source","mcoa");
			return "subSystem/mcoa/sys/index";

		}catch(Exception e){
			model.addAttribute(FormAuthenticationFilter.DEFAULT_USERNAME_PARAM, username);
			model.addAttribute(FormAuthenticationFilter.DEFAULT_MESSAGE_PARAM, e.getMessage());
			return "subSystem/mcoa/sys/sysLogin";
		}
	}

//	//用户刷新页面
	@RequestMapping(value = "/mcoa/login", method = RequestMethod.GET)
	public String getLoginMc(HttpServletRequest request,Model model){
		User user = UserUtils.getLoginUser();
		if(user == null || !SecurityUtils.getSubject().isAuthenticated()){
			return "subSystem/mcoa/sys/sysLogin";
		}
		model.addAttribute("source","mcoa");
		return "subSystem/"+getUrlByUserType()+"/sys/index";
	}
}
